/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/UiListPattern.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of tel.num.pattern filter items-specific list view
               and related container control (listbox).

 Notes:

 ============================================================================
*/


#ifndef UI_LIST_PATTERN_H_JP
#define UI_LIST_PATTERN_H_JP


// INCLUDES

#include "UiListBase.h"          // CListBaseView,
                                 // CListBaseContainer
#include "UiEditPattern.h"       // MDataForEditPattern


// FORWARD DECLARATIONS

class MSaTelnumPatternDataCache;        // "SaDataModel.h"


// CLASS DECLARATIONS

// ---------------------------------------------------------------------------
// CListPatternView
// ---------------------------------------------------------------------------

/**
 * Tel.num.pattern filter items-specific view that owns container control
 * for filter items listing (CListPatternContainer).
 *
 * @see CListPatternContainer
 */
class CListPatternView : public CListBaseView
                       , public MDataForEditPattern
    {
public: // Constructors

    /**
     * Two-phased construction.
     *
     * @param aEditViewId  UID of the corresponding edit view.
     * @param aDataCache   Provider of "data cache" for tel.num.pattern filter items.
     */
    static CListPatternView* NewLC( TUid aEditViewId,
                                    MSaTelnumPatternDataCache* aDataCache );

    /**
     * Two-phased construction.
     *
     * @param aEditViewId  UID of the corresponding edit view.
     * @param aDataCache   Provider of "data cache" for tel.num.pattern filter items.
     */
    static CListPatternView* NewL( TUid aEditViewId,
                                   MSaTelnumPatternDataCache* aDataCache );

private: // Constructor

    /**
     * Default C++ constructor.
     *
     * @param aEditViewId  UID of the corresponding edit view.
     * @param aDataCache   Provider of "data cache" for sender group filter items.
     */
    CListPatternView(TUid aEditViewId, MSaTelnumPatternDataCache* aDataCache);

public: // From CAknView

    TUid Id() const;

public: // From MDataForEditPattern

    inline TSaTelnumPatternCacheItem& GetPatternHeader()
        {
        return iPatternHeader;
        };
    inline TSaFilterItemSettings& GetSettings()
        {
        return iSettings;
        }

protected: // From CListBaseView

    CListBaseContainer* CreateContainerL();

    TBool OnItemAddBeforeEditViewL();
    void  OnItemAddAfterEditViewL(TBool aCommit);
    TBool OnItemChangeBeforeEditViewL(TInt aIndex);
    void  OnItemChangeAfterEditViewL(TBool aCommit);
    void  OnItemMoveL(TInt aIndex, TBool aUp);
    void  OnItemRemoveL(TInt aIndex);

private: // Data members

    TUint iPatternIndex;
    TSaTelnumPatternCacheItem iPatternHeader;
    MSaTelnumPatternDataCache* iDataCache;

    }; // CListPatternView


// ---------------------------------------------------------------------------
// CListPatternContainer
// ---------------------------------------------------------------------------

/**
 * Tel.num.pattern filter items-specific container control for filter items
 * listing (in the form of a listbox).
 */
class CListPatternContainer : public CListBaseContainer
    {
public: // Constructors and destructor

    /**
     * Two-phased construction.
     *
     * @param aViewUid          Identification of a view owning this container control.
     * @param aRect             Bounding rectangle.
     * @param aParent           Owning parent, or NULL.
     * @param aCommandObserver  Command observer.
     * @param aPatternCache     "Data cache" for tel.num.pattern filter items.
     */
    static CListPatternContainer* NewL( TUid aViewUid, const TRect& aRect,
                                        const CCoeControl* aParent,
                                        MEikCommandObserver* aCommandObserver,
                                        const CSaTelnumPatternCache* aPatternCache );

    /**
     * Two-phased construction.
     *
     * @param aViewUid          Identification of a view owning this container control.
     * @param aRect             Bounding rectangle.
     * @param aParent           Owning parent, or NULL.
     * @param aCommandObserver  Command observer.
     * @param aPatternCache     "Data cache" for tel.num.pattern filter items.
     */
    static CListPatternContainer* NewLC( TUid aViewUid, const TRect& aRect,
                                         const CCoeControl* aParent,
                                         MEikCommandObserver* aCommandObserver,
                                         const CSaTelnumPatternCache* aPatternCache );

    /**
     * Destructor.
     */
    ~CListPatternContainer();

private: // Constructor

    /**
     * Default C++ constructor.
     *
     * @param aViewUid          Identification of a view owning this container control.
     * @param aCommandObserver  Bounding rectangle.
     * @param aPatternCache     "Data cache" for tel.num.pattern filter items.
     */
    CListPatternContainer( TUid aViewUid,
                           MEikCommandObserver* aCommandObserver,
                           const CSaTelnumPatternCache* aPatternCache );

protected: // From CListBaseContainer

    void CreateListboxL();
    inline TInt CacheItemsCount();
    inline void CacheItemL(TDes& aFormatted, TInt aIndex);

private: // Data members

    const CSaTelnumPatternCache* iPatternCache;

    }; // CListPatternContainer


#endif // UI_LIST_PATTERN_H_JP
