/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/UiListGroup.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of sender group filter items-specific list view
               and related container control (listbox).

 Notes:

 ============================================================================
*/


#ifndef UI_LIST_GROUP_H_JP
#define UI_LIST_GROUP_H_JP


// INCLUDES

#include "UiListBase.h"          // CListBaseView,
                                 // CListBaseContainer
#include "UiEditGroup.h"         // MDataForEditGroup


// FORWARD DECLARATIONS

class MSaSenderGroupDataCache;          // "SaDataModel.h"


// CLASS DECLARATIONS

// ---------------------------------------------------------------------------
// CListGroupView
// ---------------------------------------------------------------------------

/**
 * Sender group filter items-specific view that owns container control
 * for filter items listing (CListGroupContainer).
 *
 * @see CListGroupContainer
 */
class CListGroupView : public CListBaseView
                     , public MDataForEditGroup
    {
public: // Constructors

    /**
     * Two-phased construction.
     *
     * @param aEditViewId  UID of the corresponding edit view.
     * @param aDataCache   Provider of "data cache" for sender group filter items.
     */
    static CListGroupView* NewLC( TUid aEditViewId,
                                  MSaSenderGroupDataCache* aDataCache );

    /**
     * Two-phased construction.
     *
     * @param aEditViewId  UID of the corresponding edit view.
     * @param aDataCache   Provider of "data cache" for sender group filter items.
     */
    static CListGroupView* NewL( TUid aEditViewId,
                                 MSaSenderGroupDataCache* aDataCache );

private: // Constructor

    /**
     * Default C++ constructor.
     *
     * @param aEditViewId  UID of the corresponding edit view.
     * @param aDataCache   Provider of "data cache" for sender group filter items.
     */
    CListGroupView(TUid aEditViewId, MSaSenderGroupDataCache* aDataCache);

public: // From CAknView

    TUid Id() const;

public: // From MDataForEditGroup

    inline TFilterItemHeader& GetGroupHeader()
        {
        return iGroupName;
        };
    inline TSaFilterItemSettings& GetSettings()
        {
        return iSettings;
        }

protected: // From CListBaseView

    CListBaseContainer* CreateContainerL();

    TBool OnItemAddBeforeEditViewL();
    void  OnItemAddAfterEditViewL(TBool aCommit);
    TBool OnItemChangeBeforeEditViewL(TInt aIndex);
    void  OnItemChangeAfterEditViewL(TBool aCommit);
    void  OnItemMoveL(TInt aIndex, TBool aUp);
    void  OnItemRemoveL(TInt aIndex);

public: // New methods

    /**
     * Shows popup listbox to select a contact group to use with new filter
     * item.
     *
     * @param aItemArray  Array of group's labels
     * @return  Index of selected group or -1.
     */
    static TInt RunQueryGroupsL(CDesCArray& aItemArray);

private: // Data members

    TUint iGroupIndex;
    TContactItemId iGroupId;
    TFilterItemHeader iGroupName;
    MSaSenderGroupDataCache* iDataCache;

    }; // CListGroupView


// ---------------------------------------------------------------------------
// CListGroupContainer
// ---------------------------------------------------------------------------

/**
 * Sender group filter items-specific container control for filter items
 * listing (in the form of a listbox).
 */
class CListGroupContainer : public CListBaseContainer
    {
public: // Constructors and destructor

    /**
     * Two-phased construction.
     *
     * @param aViewUid          Identification of a view owning this container control.
     * @param aRect             Bounding rectangle.
     * @param aParent           Owning parent, or NULL.
     * @param aCommandObserver  Command observer.
     * @param aGroupCache       "Data cache" for sender group filter items.
     */
    static CListGroupContainer* NewL( TUid aViewUid, const TRect& aRect,
                                      const CCoeControl* aParent,
                                      MEikCommandObserver* aCommandObserver,
                                      const CSaSenderGroupCache* aGroupCache );

    /**
     * Two-phased construction.
     *
     * @param aViewUid          Identification of a view owning this container control.
     * @param aRect             Bounding rectangle.
     * @param aParent           Owning parent, or NULL.
     * @param aCommandObserver  Command observer.
     * @param aGroupCache       "Data cache" for sender group filter items.
     */
    static CListGroupContainer* NewLC( TUid aViewUid, const TRect& aRect,
                                       const CCoeControl* aParent,
                                       MEikCommandObserver* aCommandObserver,
                                       const CSaSenderGroupCache* aGroupCache );

    /**
     * Destructor.
     */
    ~CListGroupContainer();

private: // Constructor

    /**
     * Default C++ constructor.
     *
     * @param aViewUid          Identification of a view owning this container control.
     * @param aCommandObserver  Bounding rectangle.
     * @param aGroupCache       "Data cache" for sender group filter items.
     */
    CListGroupContainer( TUid aViewUid,
                         MEikCommandObserver* aCommandObserver,
                         const CSaSenderGroupCache* aGroupCache );

protected: // From CListBaseContainer

    void CreateListboxL();
    inline TInt CacheItemsCount();
    inline void CacheItemL(TDes& aFormatted, TInt aIndex);

private: // Data members

    const CSaSenderGroupCache* iGroupCache;

    }; // CListGroupContainer


#endif // UI_LIST_GROUP_H_JP
