/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/UiEditPattern.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of tel.num.pattern filter items-specific edit view
               and related container control (setting item list).

 Notes:

 ============================================================================
*/


#ifndef UI_EDIT_PATTERN_H_JP
#define UI_EDIT_PATTERN_H_JP


// INCLUDES

#include "UiEditBase.h"


// CLASS DECLARATIONS


// ---------------------------------------------------------------------------
// MDataForEditPattern
// ---------------------------------------------------------------------------

/**
 * Mixin class providing access to data members manipulated within
 * tel.num.pattern filter item editing.
 */
class MDataForEditPattern
    {
public: // Interface methods

    /**
     * Gets reference to filter item header.
     *
     * @return  Reference to filter item header.
     */
    virtual TSaTelnumPatternCacheItem& GetPatternHeader()=0;

    /**
     * Gets referece to filter item settings.
     *
     * @return  Referece to filter item settings.
     */
    virtual TSaFilterItemSettings& GetSettings()=0;

    }; // MDataForEditPattern


// ---------------------------------------------------------------------------
// CEditPatternContainer
// ---------------------------------------------------------------------------

/**
 * Tel.num.pattern filter items-specific container control for filter items
 * editing (in the form of a setting item list).
 */
class CEditPatternContainer : public CEditBaseContainer
    {
public: // Constructors and destructor

    CEditPatternContainer( TUid aViewId,
                           TSaTelnumPatternCacheItem& aPatternHeader,
                           TSaFilterItemSettings& aSettings,
                           MEikCommandObserver* aCommandObserver );
    ~CEditPatternContainer();

public: // From CEditBaseContainer

    void EditItemL(TInt aIndex, TBool aCalledFromMenu);

protected: // From CEditBaseContainer

    CAknSettingItem* CreateSettingItemL(TInt id);

private: // Data members

    TSaTelnumPatternCacheItem& iPatternHeader;

    }; // CEditPatternContainer


// ---------------------------------------------------------------------------
// CEditPatternView
// ---------------------------------------------------------------------------

/**
 * Tel.num.pattern filter items-specific view that owns container control for
 * filter items editing (in the form of a setting item list).
 */
class CEditPatternView : public CEditBaseView
    {
public: // Two-phased constructors

    static CEditPatternView* NewL(MDataForEditPattern& aDataForEditPattern);
    static CEditPatternView* NewLC(MDataForEditPattern& aDataForEditPattern);

private: // Constructor

    CEditPatternView (MDataForEditPattern& aDataForEditPattern);

protected: // From CEditBaseView

    inline CEditBaseContainer* ItemSettingList()
        {
        return static_cast<CEditBaseContainer *>(new (ELeave)
            CEditPatternContainer( Id(), iDataForEditPattern.GetPatternHeader(),
                                   iDataForEditPattern.GetSettings(), this ));
        };

    inline HBufC* StatusPaneTextLC() const;

public: // From CAknView

    TUid Id() const;
    void HandleCommandL( TInt aCommand );

private: // Data members

    MDataForEditPattern& iDataForEditPattern;

    }; // CEditPatternView


#endif // UI_EDIT_PATTERN_H_JP
