/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/UiEditGroup.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of sender group filter items-specific edit view
               and related container control (setting item list).

 Notes:

 ============================================================================
*/


#ifndef UI_EDIT_GROUP_H_JP
#define UI_EDIT_GROUP_H_JP


// INCLUDES

#include "UiEditBase.h"


// CLASS DECLARATIONS


// ---------------------------------------------------------------------------
// MDataForEditGroup
// ---------------------------------------------------------------------------

/**
 * Mixin class providing access to data members manipulated within sender group
 * filter item editing.
 */
class MDataForEditGroup
    {
public: // Interface methods

    /**
     * Gets reference to filter item header.
     *
     * @return  Reference to filter item header.
     */
    virtual TFilterItemHeader& GetGroupHeader()=0;

    /**
     * Gets referece to filter item settings.
     *
     * @return  Referece to filter item settings.
     */
    virtual TSaFilterItemSettings& GetSettings()=0;

    }; // MDataForEditGroup


// ---------------------------------------------------------------------------
// CEditGroupContainer
// ---------------------------------------------------------------------------

/**
 * Sender group filter items-specific container control for filter items
 * editing (in the form of a setting item list).
 */
class CEditGroupContainer : public CEditBaseContainer
    {
public: // Constructors and destructor

    CEditGroupContainer( TUid aViewId,
                         TSaFilterItemSettings& aSettings,
                         MEikCommandObserver* aCommandObserver );
    ~CEditGroupContainer();

public: // From CEditBaseContainer

    void EditItemL( TInt aIndex, TBool aCalledFromMenu );

protected: // From CEditBaseContainer

    CAknSettingItem* CreateSettingItemL( TInt id );

    }; // CEditGroupContainer


// ---------------------------------------------------------------------------
// CEditGroupView
// ---------------------------------------------------------------------------

/**
 * Sender group filter items-specific view that owns container control for
 * filter items editing (in the form of a setting item list).
 */
class CEditGroupView : public CEditBaseView
    {
public: // Two-phased constructors

    static CEditGroupView* NewL(MDataForEditGroup& aDataForEditGroup);
    static CEditGroupView* NewLC(MDataForEditGroup& aDataForEditGroup);

private: // Constructor

    CEditGroupView (MDataForEditGroup& aDataForEditGroup);

protected: // From CEditBaseView

    inline CEditBaseContainer* ItemSettingList()
        {
        return static_cast<CEditBaseContainer *>(new (ELeave)
            CEditGroupContainer( Id(), iDataForEditGroup.GetSettings(), this ));
        };

    inline HBufC* StatusPaneTextLC() const;

public: // From CAknView

    TUid Id() const;
    void HandleCommandL( TInt aCommand );

private: // Data members

    MDataForEditGroup& iDataForEditGroup;

    }; // CEditGroupView


#endif // UI_EDIT_GROUP_H_JP
