/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/SaEngineModuleReceive.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of engine's module for receiving incoming SMS.

 Notes:

 ============================================================================
*/


#ifndef SA_ENGINE_MODULE_RECEIVE_H_JP
#define SA_ENGINE_MODULE_RECEIVE_H_JP


// INCLUDES

#include <e32base.h>            // CActive | euser.lib

#include <f32file.h>            // RFs
#include <es_sock.h>            // RSocketServ, RSocket | esock.lib


// CLASS DECLARATIONS

// ---------------------------------------------------------------------------
// MSaEngineModuleReceiveObserver
// ---------------------------------------------------------------------------

/**
 * Mixin class offering method for handling the event of incoming sms
 * (observer of CSaEngineModuleReceive).
 *
 * @see CSaEngineModuleReceive
 */
class MSaEngineModuleReceiveObserver
    {
public: // Pure virtual abstract methods of the observer

    /**
     * Handle the event of incoming sms (called by CSaEngineModuleReceive).
     *
     * @param aNumber  Tel.number of the sender of SMS.
     * @param aBody    Body text of SMS.
     */
    virtual void SmsReceivedL(const TDesC& aNumber, const TDesC& aBody)=0;

    }; // MSaEngineModuleReceiveObserver


// ---------------------------------------------------------------------------
// CSaEngineModuleReceive
// ---------------------------------------------------------------------------

/**
 * Engine's module for receiving incoming SMS in the form of active object
 * using "SMS Utilities" API.
 *
 * SMS Utilities API provides access to incoming SMS through the socket.
 */
class CSaEngineModuleReceive : public CActive
    {
public: // Constructors and destructor

    /**
     * Two-phased construction.
     *
     * @param aObserver  Reference to observer for this class.
     */
    static CSaEngineModuleReceive* NewL(MSaEngineModuleReceiveObserver& aObserver);

    /**
     * Two-phased construction.
     *
     * @param aObserver  Reference to observer for this class.
     */
    static CSaEngineModuleReceive* NewLC(MSaEngineModuleReceiveObserver& aObserver);

    /**
     * Destructor.
     */
    ~CSaEngineModuleReceive();

private: // Constructors

    /**
     * Default C++ constructor.
     *
     * @param aObserver  Reference to observer for this class.
     */
    CSaEngineModuleReceive(MSaEngineModuleReceiveObserver& aObserver);

    /**
     * Second-phase constructor.
     */
    void ConstructL();

public: // New functions

    /**
     * Starts listening for incoming SMS.
     */
    void StartListeningL();

    /**
     * Stops listening for incoming SMS.
     */
    void StopListening();

private: // From CActive

    void RunL();
    void DoCancel();
    TInt RunError(TInt aError);

private: // New function

    /**
     * Starts waiting for socket data.
     */
    void Start();

private: // Enumeration

    enum TSmsAlertsReceiveEngineState
        {
        EReceiveEngineStopped,
        EReceiveEngineStarting,
        EReceiveEngineListening,
        EReceiveEngineNotifyingSystem,
        };

private: // Data members

    MSaEngineModuleReceiveObserver& iReceiveEngineObserver;
    RFs iFs;
    RSocketServ iSocketServ;
    RSocket iSocket;
    TPckgBuf<TUint> iPckgBuf;
    TSmsAlertsReceiveEngineState iState;

    }; // CSaEngineModuleReceive


#endif // SA_ENGINE_MODULE_RECEIVE_H_JP
