/*                                                              coding: utf-8
 ============================================================================
 Name        : src/SaEngineModuleNotifyUI.cpp
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of UI part of the engine's module for notification
               about incoming SMS.

 Notes:

 ============================================================================
*/


#ifndef SA_ENGINE_MODULE_NOTIFY_UI_H_JP
#define SA_ENGINE_MODULE_NOTIFY_UI_H_JP


// INCLUDES

#include <e32base.h>            // CActive | euser.lib


// FORWARD DECLARATIONS

class CEikAppUi;                         // <eikappui.h> | eikcore.lib
class CAknGlobalConfirmationQuery;       // <aknglobalconfirmationquery.h>
                                         // | aknnotify.lib eiksrv.lib


// CONSTANTS

const TInt KMaxNoteLength = 255;


// CLASS DECLARATION

// ---------------------------------------------------------------------------
// MSaEngineModuleNotifyUIObserver
// ---------------------------------------------------------------------------

/**
 * Abstract mixin class to notify, that the note was closed.
 */
class MSaEngineModuleNotifyUIObserver
    {
public: // Interface methods

    /**
     * Called when the note was closed (using softkeys or any other key).
     */
    virtual void NoteClosedL()=0;

    }; // MSaEngineModuleNotifyUIObserver


// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI
// ---------------------------------------------------------------------------

/**
 * Active object form of wrapping CAknGlobalNote used to display notificaton
 * about received messages.
 *
 * Note: UI specific, need to be reimplemented on UIs other than S60!
 */
class CSaEngineModuleNotifyUI : public CActive
    {
public: // Constructors and destructors

    /**
     * Two-phased construction.
     *
     * @param aAppUi             Pointer to AppUi class.
     * @param aNotifyUIObserver  Object to be informed about sofktey/key
     *                           pressed within displayed note.
     */
    static CSaEngineModuleNotifyUI* NewL( CEikAppUi* aAppUi,
                                          MSaEngineModuleNotifyUIObserver& aNotifyUIObserver );

    /**
     * Two-phased construction.
     *
     * @param aAppUi             Pointer to AppUi class.
     * @param aNotifyUIObserver  Object to be informed about sofktey/key
     *                           pressed within displayed note.
     */
    static CSaEngineModuleNotifyUI* NewLC( CEikAppUi* aAppUi,
                                           MSaEngineModuleNotifyUIObserver& aNotifyUIObserver );

    /**
     * Destructor.
     */
    ~CSaEngineModuleNotifyUI();

private: // Constructors

    /**
     * Default C++ constructor.
     *
     * @param aAppUi Pointer to AppUi class.
     */
    CSaEngineModuleNotifyUI( CEikAppUi* aAppUi,
                             MSaEngineModuleNotifyUIObserver& aNotifyUIObserver );

    /**
     * Second-phase constructor.
     */
    void ConstructL();

private: // From CActive

    void RunL();
    void DoCancel();
    TInt RunError(TInt aError);

public: // New methods

    /**
     * Increase the number of received messages, about which the note informs.
     */
    void NoteAddL();

    /**
     * Cancel the note, if displayed.
     */
    void NoteCancel();

private: // Data members

    CEikAppUi* iAppUi;
    MSaEngineModuleNotifyUIObserver& iNotifyUIObserver;

    TInt iPluralSecondRangeStart;
    CAknGlobalConfirmationQuery* iGlobalConfirmationQuery;
    TInt iNumOfMessages;
    HBufC* iNoteText;

    }; // CSaEngineModuleNotifyUI


#endif // SA_ENGINE_MODULE_NOTIFY_UI_H_JP
