/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/SaEngineModuleNotify.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of engine's module for notification about
               incoming SMS.

 Notes:

 ============================================================================
*/


#ifndef SA_ENGINE_MODULE_NOTIFY_H_JP
#define SA_ENGINE_MODULE_NOTIFY_H_JP


// INCLUDES

#include <e32base.h>                     // CBase
#include <mdaaudiosampleplayer.h>        // MMdaAudioPlayerCallback | mediaclientaudio.lib,
                                         // CMdaAudioPlayerUtility
#include "SaEngineModuleNotifyUI.h"      // MSaEngineModuleNotifyUIObserver,
                                         // CSaEngineModuleNotifyUI


// FORWARD DECLARATIONS

class CEikAppUi;                         // <eikappui.h> | eikcore.lib
class CHWRMVibra;                        // <hwrmvibra.h> | hwrmvibraclient.lib
#ifdef __SERIES60_30__
    // note: extension plug-in package for S60 3rd Edition (MR) C++ SDK required
    //       <http://wiki.forum.nokia.com/index.php/SDK_API_Plug-in>
class MProfileEngine;                    // <mprofileengine.h> | profileeng.lib
#else
    // note: no extension plug-in package for C++ SDK required as this uses
    //       standard public API
class MProEngEngine;                     // <mproengengine.h> | profileengine.lib
#endif

// CLASS DECLARATION

// ---------------------------------------------------------------------------
// CSaEngineModuleNotify
// ---------------------------------------------------------------------------

/**
 * Engine module for notification about incoming SMS.
 */
class CSaEngineModuleNotify : public CBase
                            , public MMdaAudioPlayerCallback
                            , public MSaEngineModuleNotifyUIObserver
    {
public: // Constructors and destructor

    /**
     * Two-phased construction.
     *
     * @param aAppUi Pointer to AppUi class.
     */
    static CSaEngineModuleNotify* NewL(CEikAppUi* aAppUi);

    /**
     * Two-phased construction.
     *
     * @param aAppUi Pointer to AppUi class.
     */
    static CSaEngineModuleNotify* NewLC(CEikAppUi* aAppUi);

    /**
     * Destructor.
     */
    ~CSaEngineModuleNotify();

private: // Constructors

    /**
     * Default C++ constructor.
     */
    CSaEngineModuleNotify();

    /**
     * Second-phase constructor.
     *
     * @param aAppUi Pointer to AppUi class.
     */
    void ConstructL(CEikAppUi* aAppUi);

public: // From MMdaAudioPlayerCallback

    void MapcInitComplete(TInt aError, const TTimeIntervalMicroSeconds& aDuration);
    void MapcPlayComplete(TInt aError);

public: // From MSaEngineModuleNotifyUIObserver

    void NoteClosedL();

public: // New functions: notification

    /**
     * Plays specified sound file at specified volume level.
     *
     * Volume level is supposed to be between 1 and 10 (inclusive);
     * if less value is specified, the first bound is used,
     * if greater value is specified, the latter bound is used.
     *
     * @param aFileName         Filename of the sound to be played.
     * @param aVolume           Volume at which to play the sound, between 1 and 10.
     * @param aOverrideProfile  Specifies whether to override disabled tones from profile.
     */
    void PlayL(const TDesC& aFileName, TInt aVolume, TBool aOverrideProfile = EFalse);

    /**
     * If possible, starts vibration for specified period.
     *
     * In some cases, vibration may not start, for instance:
     *   - vibrating alerts are set off in user's profile
     *   - battery charger is connected
     *
     * @param aDuration  Duration in miliseconds of vibration period.
     */
    void Vibrate(TInt aDuration = 1000);

    /**
     * Displays global note about received message.
     */
    void ShowNoteL();

private: // Data members

    TBool iAudioReady;
    TBool iAudioFallback;

    CMdaAudioPlayerUtility* iAudioPlayerUtility;
    CHWRMVibra* iVibra;
    TInt iVolume;

#ifdef __SERIES60_30__
    MProfileEngine* iProfileEngine;
#else
    MProEngEngine* iProfileEngine;
#endif

    CSaEngineModuleNotifyUI* iNotifyUi;

    }; // CSaEngineModuleNotify


#endif // SA_ENGINE_MODULE_NOTIFY_H_JP
