/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/SaEngineModuleDispatch.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of engine's module for dispatching SMS into
               specified messaging folder.

 Notes:

 ============================================================================
*/


#ifndef SA_ENGINE_MODULE_DISPATCH_H_JP
#define SA_ENGINE_MODULE_DISPATCH_H_JP


// INCLUDES

#include <e32base.h>                        // CBase | euser.lib
#include <msvapi.h>                         // CMsvSession, MMsvSessionObserver,
                                            // TMsvSessionEvent | msgs.lib
#include <mtclreg.h>                        // CClientMtmRegistry | msgs.lib
#include <smsclnt.h>                        // CSmsClientMtm | smcm_gsm.lib -> smcm.lib
#include <msvstd.h>                         // TMsvId


// CONSTANTS

// undocumented values for "My Folders" folder in default messaging application
#define MSV_MY_FOLDERS_ENTRY_ID  (0x1008)
const TMsvId KMsvMyFoldersEntryId = MSV_MY_FOLDERS_ENTRY_ID; //0x1008


// CLASS DECLARATION

// ---------------------------------------------------------------------------
// CSaEngineModuleDispatch
// ---------------------------------------------------------------------------

/**
 * Engine module for dispatching SMS into specified messaging folder.
 */
class CSaEngineModuleDispatch : public CBase
                              , public MMsvSessionObserver
    {

public: // Constructors and destructor

    /**
     * Two-phased construction.
     */
    static CSaEngineModuleDispatch* NewL();

    /**
     * Two-phased construction.
     */
    static CSaEngineModuleDispatch* NewLC();

    /**
     * Destructor.
     */
    ~CSaEngineModuleDispatch();

private: // Constructors

    /**
     * Default C++ constructor.
     */
    CSaEngineModuleDispatch();

    /**
     * Second-phase constructor.
     */
    void ConstructL();

public: // From MMsvSessionObserver

    void HandleSessionEventL(TMsvSessionEvent aEvent, TAny* aArg1, TAny* aArg2, TAny* aArg3);

public: // New functions

    /**
     * Creates an SMS in specified subfolder of "My Folders".
     *
     * Message is created from specified text and sender fields
     * (both the number and name). Current date and time are used to fill
     * appropriate attributes.
     *
     * If aFolderName argument omitted or KNullDesC, standard "Inbox"
     * folder will be used.
     *
     * @param aSenderNumber  Specifies the sender -- tel.number.
     * @param aSenderName    Specifies the sender -- his/her name.
     * @param aText          Specifies the text of the message.
     * @param aFolderName    Destination folder's name (subfolder of "My Folders)
     *                       or omitted (KNullDesC) for standard "Inbox" folder.
     */
    void CreateSmsL( const TDesC& aSenderNumber, const TDesC& aSenderName,
                     const TDesC& aText, const TDesC& aFolderName = KNullDesC );

private: // New functions

    /**
     * Tries to find folder of specified name within "My Folders" folder
     * (as displayed in default messaging application).
     *
     * If not found, such folder is created.
     *
     * @param aFolderName  Specifies name of the folder to find.
     * @return  Requested folder's entry in the Message Server index.
     */
    TMsvId FindOrCreateFolderInMyFoldersL(const TDesC& aFolderName);

    /**
     * Closes session.
     *
     * @note Can be inline.
     */
    void CloseSession();

public: // Enumerations

    // status enumeration
    enum TSmsCreateEngineStatus
        {
        EDispatchEngineReady = 0,
        EDispatchEngineNotReady,
        EDispatchEngineHandling,
        };

private: // Data members

    TSmsCreateEngineStatus iStatus;

    CMsvSession* iMsvSession;
    CClientMtmRegistry* iClientMtmRegistry;
    CSmsClientMtm* iSmsClientMtm;

    }; // CSaEngineModuleDispatch


#endif // SA_ENGINE_MODULE_DISPATCH_H_JP
