/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/SaEngineCore.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of core of the engine handling incoming SMS.

 Notes:

 ============================================================================
*/


#ifndef SA_ENGINE_CORE_H_JP
#define SA_ENGINE_CORE_H_JP


// INCLUDES

#include <e32base.h>                // CBase
#include "SaEngineModuleReceive.h"  // MSaEngineModuleReceiveObserver, CSaEngineModuleReceive


// FORWARD DECLARATIONS

class CEikAppUi;                    // <eikappui.h> | eikcore.lib
class MSaDataCache;                 // "SaDataModel.h"
class CSaEngineModuleDispatch;      // "SaEngineModuleDispatch.h"
class CSaEngineModuleNotify;        // "SaEngineModuleNotify.h"


// CLASS DECLARATIONS

// ---------------------------------------------------------------------------
// CSaEngineCore
// ---------------------------------------------------------------------------

/**
 * Core of the engine for SMS receipt and notification about this event.
 *
 * It uses its modules (CSaEngineModuleReceive, CSaEngineModuleDispatch,
 * CSaEngineModuleNotify) to handle the event of incoming SMS, for filtering
 * according to filter items using "data cache" povider (specified with
 * aStorage argument of public constructors), for dispatching message
 * to the right messaging folder and eventually for notification about
 * the event to the user.
 */
class CSaEngineCore : public CBase
                    , public MSaEngineModuleReceiveObserver
    {
public: // Constructors and destructor

    /**
     * Two-phased construction.
     *
     * @param aStorage "Data cache" povider.
     * @param aAppUi Pointer to AppUi class.
     */
    static CSaEngineCore* NewL(MSaDataCache& aStorage, CEikAppUi* aAppUi);

    /**
     * Two-phased construction.
     *
     * @param aStorage "Data cache" povider.
     * @param aAppUi Pointer to AppUi class.
     */
    static CSaEngineCore* NewLC(MSaDataCache& aStorage, CEikAppUi* aAppUi);

    /**
     * Destructor.
     */
    ~CSaEngineCore();

private: // Constructors

    /**
     * Default C++ constructor.
     *
     * @param aStorage "Data cache" povider.
     */
    CSaEngineCore(MSaDataCache& aStorage);

    /**
     * Second-phase constructor.
     *
     * @param aAppUi Pointer to AppUi class.
     */
    void ConstructL(CEikAppUi* aAppUi);

public: // From MSmsAlertsReceiveEngineObserver

    void SmsReceivedL(const TDesC& aTelnum, const TDesC& aBody);

private: // Data members

#ifndef __WINS__
    // SaEngineModuleReceive module uses calls, that can't be used
    // in emulator build
    CSaEngineModuleReceive* iReceiveModule;
#endif

    CSaEngineModuleDispatch* iDispatchModule;
    CSaEngineModuleNotify* iNotifyModule;

    MSaDataCache& iStorage;

    }; // CSaEngineCore


#endif // SA_ENGINE_CORE_H_JP
