/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/Document.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of application's document model.

 Notes:

 ============================================================================
*/


#ifndef DOCUMENT_H_JP
#define DOCUMENT_H_JP


// INCLUDES

#include <akndoc.h>                 // CAknDocument | avkon.lib eikcore.lib eiksrv.lib
#include <cntdef.h>                 // TContactItemId, CContactIdArray

#include "SaDataModel.h"            // MSaDataCache, CSaDataStorageBase
#include "SaDataModelTypes.h"       // CSaSenderGroupCache,
                                    // TFilterItemHeader, TSaTelnumPatternCacheItem
                                    // CSaSenderGroupCache, CSaTelnumPatternCache

// FORWARD DECLARATIONS

class CSaEngineCore;                // "SaEngineCore.h"


// CONSTANTS

const TInt KCacheReservedItems=2;


// CLASS DECLARATIONS

// ---------------------------------------------------------------------------
// CDocument
// ---------------------------------------------------------------------------

/**
 * Application document's class representation required by the S60
 * application framework.
 */
class CDocument : public CAknDocument
                , public MSaDataCache
    {
public: // Constructor and destructor

    /**
     * Two-phased construction.
     *
     * @param aApplication  Reference to the instance of application class.
     * @param aFs           Reference to the handle to file server session.
     */
    static CDocument* NewL(CEikApplication& aApplication, RFs& aFs);

    /**
     * Destructor.
     */
    virtual ~CDocument();

private: // Constructors

    /**
     * Default C++ constructor.
     *
     * @param aApp  Reference to the instance of application class.
     * @param aFs   Reference to the handle to file server session.
     */
    CDocument(CEikApplication& aApplication, RFs& aFs);

    /**
     * Second-phase constructor.
     */
    void ConstructL();

public: // From CEikDocument (application framework method)

    /**
     * Creates the application UI object for this document.
     *
     * @return Instance of application UI object.
     */
    CEikAppUi* CreateAppUiL();

public: // From MSaSenderGroupDataStorage

    TUint SenderGroupCountL() const;
    void  SenderGroupsResetL();
    void  SenderGroupAddL( TContactItemId aGroupId,
                           const TSaFilterItemSettings& aSettings,
                           const TFilterItemHeader& aGroupLabel = TPtrC(KNullDesC) );
    void  SenderGroupRemoveL(TUint aIndex);
    void  SenderGroupMoveUpDownL(TUint aIndex, TBool aUp);
    void  SenderGroupGetHeaderL(TUint aIndex, TContactItemId& aGroupId) const;
    void  SenderGroupGetSettingsL(TUint aIndex, TSaFilterItemSettings& aSettings) const;
    void  SenderGroupSetL( TUint aIndex, const TContactItemId& aGroupId,
                           const TSaFilterItemSettings& aSettings );

private: // From MSaSenderGroupDataStorage

    // Two arguments version of SenderGroupAddL() is unusable in this context.
    void  SenderGroupAddL( TContactItemId aGroupId,
                           const TSaFilterItemSettings& aSettings );

public: // From MSaTelnumPatternDataStorage

    TUint TelnumPatternCountL() const;
    void  TelnumPatternResetL();
    void  TelnumPatternAddL( const TSaTelnumPatternCacheItem& aPatternHeader,
                             const TSaFilterItemSettings& aSettings );
    void  TelnumPatternRemoveL(TUint aIndex);
    void  TelnumPatternMoveUpDownL(TUint aIndex, TBool aUp);
    void  TelnumPatternGetHeaderL( TUint aIndex,
                                   TSaTelnumPatternCacheItem& aPatternHeader) const;
    void  TelnumPatternGetSettingsL(TUint aIndex, TSaFilterItemSettings& aSettings) const;
    void  TelnumPatternSetL( TUint aIndex,
                             const TSaTelnumPatternCacheItem& aPatternHeader,
                             const TSaFilterItemSettings& aSettings );

public: // From MSaSenderGroupDataCache

    TBool FirstMatchingSenderGroupL( const CContactIdArray& aSenderGroupIds,
                                     TFilterItemHeader& aGroupLabel,
                                     TSaFilterItemSettings& aSettings ) const;
    const CSaSenderGroupCache* SenderGroupCache() const;

public: // From MSaTelnumPatternDataCache

    TBool FirstMatchingTelnumPatternL( const TDesC& aTelnum,
                                       TFilterItemHeader& aPatternName,
                                       TSaFilterItemSettings& aSettings ) const;
    const CSaTelnumPatternCache* TelnumPatternCache() const;

private: // Private utility methods

    /**
     * Creates and fill caches for particular filter types.
     */
    void ConstructAndFillCachesL();


private: // Data members

    CSaDataStorageBase* iStorage;
    CSaSenderGroupCache* iSenderGroupCache;
    CSaTelnumPatternCache* iTelnumPatternCache;
    CSaEngineCore* iMainEngine;

    RFs& iFs;

    }; // CDocument


#endif // DOCUMENT_H_JP
