/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/Application.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of application's entry point
               and class representation.

 Notes:

 ============================================================================
*/


#ifndef APPLICATION_H_JP
#define APPLICATION_H_JP


// INCLUDES

#include <aknapp.h>


// CONSTANTS

const TUid KUidSmsAlertsApplication = { 0xA9E722B4 };


// CLASS DECLARATIONS

// ---------------------------------------------------------------------------
// CApplication
// ---------------------------------------------------------------------------

/**
 * Application's class representation required by the S60 application framework.
 */
class CApplication : public CAknApplication
    {
private:  // Application framework methods

    /**
     * Returns the application's UID.
     *
     * @return  UID for this application.
     */
    TUid AppDllUid() const;

    /**
     * Creates the application's document.
     *
     * @return  Pointer to the created document object.
     */
    CApaDocument* CreateDocumentL();

    }; // CApplication


#endif // APPLICATION_H_JP
