/*                                                              coding: utf-8
 ============================================================================
 Name        : inc/AppUi.h
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Declaration of application's user interface model based
               on view architecture.

 Notes:

 ============================================================================
*/


#ifndef APPUI_H_JP
#define APPUI_H_JP


// INCLUDES

#include <aknviewappui.h>           // CAknViewAppUi | avkon.lib eikcore.lib eiksrv.lib


// FORWARD DECLARATIONS

class CAknNavigationDecorator;      // <aknnavide.h> | avkon.lib
class CAknTabGroup;                 // <akntabgrp.h> | avkon.lib

class CListBaseView;                // "SmsAlertsListBase.h"
class CEditBaseView;                // "SmsAlertsEditBase.h"
class MSaDataCache;                 // "SaDataModel.h"


// CLASS DECLARATIONS

// ---------------------------------------------------------------------------
// CAppUi
// ---------------------------------------------------------------------------

/**
 * Application's view architecture-based user interface.
 *
 * The class handles application-wide aspects of the user interface
 * (for instance view management and status pane).
 */
class CAppUi : public CAknViewAppUi
    {
public: // Constructor and destructor
    /**
     * Default C++ constructor.
     *
     * @param aDataCache  Pointer to filter items "data cache" provider
     *                    for particular filter types.
     */
    CAppUi(MSaDataCache* aDataCache);

    /**
     * Destructor.
     */
    virtual ~CAppUi();

    /**
     * Second-phase constructor called by the application framework.
     *
     * Initializes itself and application's views.
     */
    void ConstructL();

public: // From CCoeAppUi

    TKeyResponse HandleKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType);

public: // From CEikAppUi

    void HandleCommandL(TInt aCommand);
    void HandleResourceChangeL(TInt aType);

public: // From CAknAppUi

    void HandleViewDeactivation( const TVwsViewId& aViewIdToBeDeactivated,
                                 const TVwsViewId& aNewlyActivatedViewId );

private: // New methods

    void InitializeViewsL();

public: // New methods

    void SetActiveTabByViewId(TUid aViewId);
    TBool HandleRightSoftKeyPressedL();

private: // Data members

    CAknNavigationDecorator* iNaviDecorator;
    CAknTabGroup* iNaviTabs;

    // views (when the number of views grows, arrays of list/edit view
    // can be considered)
    CListBaseView* iListGroupView;
    CListBaseView* iListPatternView;
    CEditBaseView* iEditGroupView;
    CEditBaseView* iEditPatternView;

    MSaDataCache* iDataCache;

    }; // CAppUi


#endif // APPUI_H_JP
