//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    MCModule.h                          \n
 * Date:    2008/9                              \n
 *
 * $Id:$
 */

#ifndef MDS_MCModule_H
#define MDS_MCModule_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * MDSTk based Marching cubes module
 */
class CMarchinCubesModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    //MDS_CLASS_NAME(CMarchinCubesModule);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CMarchinCubesModule);

public:
    //! Default constructor.
    CMarchinCubesModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CMarchinCubesModule();

    //! Progress function
    bool ProgressFunction(int count, int max)       { std::cout << std::endl << "Marching cubes Z = " << count << " / " << max; return true; };

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);


    // Module parameters
    int             m_iLow;                  //! Low threshold for Marching Cubes voxels segmentation.
    int             m_iHigh;                 //! High threshold for Marching Cubes voxels segmentation.
    bool            m_bReduce;               //! State for vertices reduction on strait edgea and on flat regions. Default value is false.
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CMarchinCubesModule::tSmartPtr    CMarchinCubesModulePtr;


#endif // MDS_MCModule_H

