//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    LoadSTLModule.h                     \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 */

#ifndef MDS_LoadSTLModule_H
#define MDS_LoadSTLModule_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module for translation from MDSTk::VectorEntity library native TRI format into STL format.
 */
class CLoadSTLModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    //MDS_CLASS_NAME(CLoadSTLModule);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CLoadSTLModule);

public:
    //! Default constructor.
    CLoadSTLModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CLoadSTLModule();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CLoadSTLModule::tSmartPtr    CLoadSTLModulePtr;


#endif // MDS_LoadSTLModule_H

