///////////////////////////////////////////////////////////////////////////////
// $Id$
//
// EasyDent
// Navigation and implants planning software for dentistry.
//
// Copyright (c) 2008 by 3Dim Laboratory s.r.o.
//
///////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// Header file for CSmoothing class

#ifndef MC_SMOOTHING_H
#define MC_SMOOTHING_H

////////////////////////////////////////////////////////////
// Includes

#include <VectorEntity/mctris.h>

// MDSTk
#include <MDSTk/Image/mdsDensityVolume.h>
#include <MDSTk/Module/mdsSerializable.h>
#include <MDSTk/Module/mdsProgress.h>

// STL
#include <vector>

////////////////////////////////////////////////////////////
//! CSmoothing algorithm implementation class.
//! Implements G. Taubin - Signal processing polygonal surface fairing.

class CSmoothing : public mds::mod::CProgress
	{
		private:

		public:
            //! Smoothing class constructor.
            CSmoothing()                        {};

            //! Smoothing class destructor.
            ~CSmoothing()                       {};

            //! Smooth input mesh using G. Taubin - Signal processing polygonal surface fairing
            bool Smooth(vctl::MCTriS & tris, int repeating, double & lambda, double & k_pb);

		private:

            //! Smooth coordinates of input vertex.
            bool SmoothVertex(vctl::MCVertex * actual_vertex, vctl::MCPoint3D & smoothed_point, double & smooth_factor);

            //! Find neighbor vertices (by edges) for input vertex, looking for neighbors in given layers (rings).
            bool GetNeighborVertices(vctl::MCVertex * actual_vertex, std::vector<vctl::MCVertex *> & neighbour_vertex, int neighbour_layers);
	};

#endif // MC_SMOOTHING_H

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
