//---------------------------------------------------------------------------

#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>

#pragma hdrstop

//---------------------------------------------------------------------------

int FrameCount;
int ClusterCount;
int PCADimension;
int ClusterCountPCADimension;
float * Data = NULL;

float * ClusterDistances = NULL;

float * Norms = NULL;

float MaxOutputFramesRatio;
int MaxOutputFrames;

int OutputColumns;

#define ClusterLikelyhood(Frame,Cluster) (Data[(Frame)*ClusterCountPCADimension+(Cluster)])
#define PCAVectorValue(Frame,Index) (Data[(Frame)*ClusterCountPCADimension+ClusterCount+(Index)])
#define ClusterClusterDistance(Cluster0,Cluster1) (ClusterDistances[ClusterCount*(Cluster1)+(Cluster0)])

int LoadData(char * Name)
{
	if (Data!=NULL) {
		free(Data);
		Data = NULL;
		ClusterDistances = NULL;
	}

	FILE * f = fopen(Name,"rb");
	if (f==NULL) {
		return 0;
	}
	if (fread(&FrameCount,sizeof(int),1,f)!=1) return 0;
	if (fread(&ClusterCount,sizeof(int),1,f)!=1) return 0;
	if (fread(&PCADimension,sizeof(int),1,f)!=1) return 0;
	ClusterCountPCADimension = ClusterCount+PCADimension;

	Data = (float *)malloc(sizeof(float)*((ClusterCount+PCADimension)*FrameCount+ClusterCount*ClusterCount));
	if (Data==NULL) {
		fclose(f);
		return 0;
	}
/* In case of part by part reading
	for (int i = 0; i < FrameCount; i++) {
		if (fread(Data+i*(ClusterCount+PCADimension),sizeof(float),ClusterCount+PCADimension,f)
			!=(ClusterCount+PCADimension))
		{
			fclose(f);
			return 0;
		}
	}
	if (fread(Data+FrameCount*(ClusterCount+PCADimension),sizeof(float),ClusterCount*ClusterCount,f)
		!=(ClusterCount*ClusterCount))
	{
		fclose(f);
		return 0;
	}
*/
	if (fread(Data,sizeof(float),FrameCount*(ClusterCount+PCADimension)+ClusterCount*ClusterCount,f)
		!=(unsigned)(FrameCount*(ClusterCount+PCADimension)+ClusterCount*ClusterCount))
	{
		fclose(f);
		return 0;
	}

	ClusterDistances = Data+FrameCount*(ClusterCount+PCADimension);

	return 1;
}

//Pre-calculates the norms for mutual cluster distances in order to easier provide
//the output bar lightness data (they are determined by the distances of the curent
//and the other clusters).
int CreateNorms()
{
	if (Norms!=0) {
		free(Norms);
	}

	Norms = (float *)malloc(sizeof(float)*ClusterCount);

	if (Norms==NULL) {
		return 0;
	}

	for (int i = 0; i < ClusterCount; i++) {
		float DistanceMax = 0;
		for (int j = 0; j < ClusterCount; j++) {
			if (ClusterClusterDistance(i,j)>DistanceMax) {
				DistanceMax = ClusterClusterDistance(i,j);
			}
		}
		Norms[i] = DistanceMax;
	}

	return 1;
}

typedef struct {
	int FrameFrom;
	int FrameTo;
	float Speedup;
	int Cluster;
	float Energy;
	int MaxFrames;
} Interval;

Interval * Intervals = NULL;
int IntervalCount = 0;

//Calculates energa of an interval normalized by the size of the interval so that
//"relative measure of speed of change" is know in order to determine speedup.
float GetIntervalEnergy(int Index)
{
	if (Intervals==NULL) {
		return 0;
	}

	if (IntervalCount<=Index) {
		return 0;
	}

	float Energy = 0;
	for (int i = Intervals[Index].FrameFrom; i < Intervals[Index].FrameTo; i++) {
		for (int j = 0; j < PCADimension; j++) {
			Energy += PCAVectorValue(i,j)*PCAVectorValue(i,j);
		}
	}
	Energy = sqrt(Energy)/(Intervals[Index].FrameTo-Intervals[Index].FrameFrom);
	return Energy;
}

//Determines the measure of difference of a frame from the cluster through usage
//of both likelyhood of the frame belonging to the cluster and the distance between
//the clusters. Note, that this is just an estimation...
float GetFrameDifference(int Frame,int Cluster)
{
   float Difference = 0;

   if (Frame>=FrameCount) {
	   return Difference;
   }
   if (Cluster>ClusterCount) {
	   return Difference;
   }
   if (Data==NULL) {
	   return Difference;
   }
   for (int i = 0; i<ClusterCount; i++) {
	   Difference += ClusterLikelyhood(Frame,i)*ClusterClusterDistance(Cluster,i);
   }
   return Difference;
}

//This function detects the worst interval of the detected ones based on the size
//of the interval inclusing the energy of the interval. Prior to calling of this
//function, the intervals "Speedup" should be adjusted so that it works properly.
//The Cluster equal to -1 means "all clusters", other values data for just one.
int GetWorstInterval(int Cluster)
{
	float MinSize = 1000000.; //It is expected that the video will never have this number of frames
	float MinInterval = -1; //If the function returns this value, no interval was found.

	if (Intervals==NULL) {
		return -1;
	}
	int Clusters = 0;
	for (int i = 0; i < IntervalCount; i++) {
		if ((Cluster==-1)||(Cluster==Intervals[i].Cluster)) {
			if (MinSize>(Intervals[i].FrameTo-Intervals[i].FrameFrom)*Intervals[i].Speedup) {
				MinSize = (Intervals[i].FrameTo-Intervals[i].FrameFrom)*Intervals[i].Speedup;
				MinInterval = i;
			}
			++Clusters;
		}
	}
	if (Clusters<=1) {
		return -1;
	}
	return MinInterval;
}

//This function adjusts the interval speedups based on the energies. Note that
//SetIntervalEnergy function must be called prior to this function.
int AdjustIntervalSpeedup(float MaxSpeedup,float DefaultEnergy,float NormFactor,int MinFrames,int MaxFrames)
{
	if (Intervals==NULL) {
		return 0;
	}
	for (int i = 0; i < IntervalCount; i++) {
		Intervals[i].Speedup = DefaultEnergy+NormFactor*Intervals[i].Energy;
		if ((Intervals[i].FrameTo-Intervals[i].FrameFrom)>MaxFrames) {
			Intervals[i].MaxFrames = MaxFrames; // This is the only place that changes
		}
		if (Intervals[i].Speedup<MaxSpeedup) {
			Intervals[i].Speedup = MaxSpeedup;
		}
//		if ((Intervals[i].FrameTo-Intervals[i].FrameFrom)*Intervals[i].Speedup<MinFrames) {
		if ((Intervals[i].FrameTo-Intervals[i].FrameFrom)*Intervals[i].Speedup<MinFrames) {
			Intervals[i].Speedup = (float)MinFrames/(Intervals[i].FrameTo-Intervals[i].FrameFrom);
		}
		if (Intervals[i].Speedup>1) {
			Intervals[i].Speedup = 1;
		}
	}
	return 1;
}

int RemoveInterval(int Index)
{
	if (Intervals==NULL) {
		return 0;
	}
	if (Index>=IntervalCount) {
		return 0;
	}
	for (int i = Index; i < IntervalCount-1; i++) {
		Intervals[i] = Intervals[i+1];
	}
	--IntervalCount;

	return 1;
}

int GetIntervals()
{
	if (Intervals!=NULL) {
		free(Intervals);
		Intervals = NULL;
	}

	Intervals = (Interval *)malloc(sizeof(Interval)*(FrameCount+1));
	if (Intervals==NULL) {
		return 0;
	}

	IntervalCount = 0;

	int LastCluster = 0;
	int LastFrame = 0;

	for (int i = 0; i < FrameCount; i++) {
		int Cluster = 0;
		float LikelyhoodMax = 0;
		for (int j = 0; j < ClusterCount; j++) {
			if (ClusterLikelyhood(i,j)>LikelyhoodMax) {
				LikelyhoodMax = ClusterLikelyhood(i,j);
				Cluster = j;
			}
		}
		if (Cluster!=LastCluster) {
			if (LastCluster!=0) {
				Intervals[IntervalCount].Cluster = LastCluster;
				Intervals[IntervalCount].FrameFrom = LastFrame;
				Intervals[IntervalCount].FrameTo = i;
				Intervals[IntervalCount].Speedup = 1; //Initially, it is 1
				Intervals[IntervalCount].MaxFrames = Intervals[IntervalCount].FrameTo-Intervals[IntervalCount].FrameFrom;
				++IntervalCount;
			}
			LastCluster = Cluster;
			LastFrame = i;
		}
	}

	return 1;
}

//This function just adjusts the energies for all the intervals.
int SetIntervalEnergy()
{
	for (int i = 0; i < IntervalCount; i++) {
		Intervals[i].Energy = GetIntervalEnergy(i);
	}
	return 1;
}

//Intelliget "printout" of the intervals - the complete output for video generation.
//Note, that no processing of the data takes place, all the calculations done here
//are meant just to provide nice "output bar" for the video generation.
int OutputIntervals(FILE * f)
{
	fprintf(f,"%3d %3d\n",IntervalCount,OutputColumns);
	for (int i = 0; i < IntervalCount; i++) {
		fprintf(f,"%5d %5d %2d %6.3f  ",
//			Intervals[i].FrameFrom,Intervals[i].FrameTo,Intervals[i].Cluster,Intervals[i].Speedup
			Intervals[i].FrameFrom,Intervals[i].FrameFrom+Intervals[i].MaxFrames,Intervals[i].Cluster,Intervals[i].Speedup
		);
		for (int j = 0; j < OutputColumns; j++) {
			int FrameFrom = j*FrameCount/OutputColumns;
			int FrameTo = (j+1)*FrameCount/OutputColumns;

			float MinDistance = Norms[Intervals[i].Cluster];
			for (int k = FrameFrom; k < FrameTo; k++) {
//This section could be replaced with constant table if time allows and if necessary
				int Cluster = 0;
				float LikelyhoodMax = 0;
				for (int l = 0; l < ClusterCount; l++) {
					if (ClusterLikelyhood(k,l)>LikelyhoodMax) {
						LikelyhoodMax = ClusterLikelyhood(k,l);
						Cluster = l;
					}
				}
//End of this section
				if (MinDistance>=ClusterClusterDistance(Intervals[i].Cluster,Cluster)) {
					MinDistance = ClusterClusterDistance(Intervals[i].Cluster,Cluster);
				}
			}
			if (((FrameFrom>=Intervals[i].FrameFrom)&&(FrameFrom<Intervals[i].FrameTo))||((FrameTo>Intervals[i].FrameFrom)&&(FrameTo<=Intervals[i].FrameTo))||
				((Intervals[i].FrameFrom>=FrameFrom)&&(Intervals[i].FrameFrom<FrameTo))||((Intervals[i].FrameTo>FrameFrom)&&(Intervals[i].FrameTo<=FrameTo))
			) {
				fprintf(f," %3d",(int)-1);
			}
			else
			{
				if (Norms[Intervals[i].Cluster]!=0) {
					fprintf(f," %3d",(int)(255-255*(MinDistance/Norms[Intervals[i].Cluster]))); // Just to make sure
				} else
				{
                	fprintf(f," %3d",(int)(255)); // Just to make sure
                }
			}
		}
		fprintf(f,"\n");
	}

	return 1;
}

//Calculater the Intervals' total length in order to determine the relative speedup
//needed for each video segment for the generation of the output video sequence.
int GetIntervalsTotalLength()
{
	if (Intervals==NULL) {
		return 0;
	}

	int Count = 0;
	for (int i = 0; i < IntervalCount; i++) {
//		Count += (Intervals[i].FrameTo-Intervals[i].FrameFrom)*Intervals[i].Speedup;
		Count += (Intervals[i].MaxFrames)*Intervals[i].Speedup;
	}
	return Count;
}

int main(int argc, char* argv[])
{
	if (argc<3) {
		fprintf(stdout,"<Cluster_file_name> <Max_output_frame_ratio> {<Output_columns>=100 {<+ for auto file output, - for stdout, filename for file output> {<Max_speedup=0.2> <Speed_factor=5> <Min_frames=25> <Max_frames=125> <Reduce_factor=0.9>  <Frame_reduce_factor=0.9>} } }\n");
		return -1;
	}

	FILE * Out = stdout;

	if (LoadData(argv[1])==0) return -1;

	sscanf(argv[2],"%f",&MaxOutputFramesRatio);
	MaxOutputFrames = FrameCount*MaxOutputFramesRatio;

	OutputColumns = 100;
	if (argc>3) sscanf(argv[3],"%d",&OutputColumns);

	if (argc>4) {
		char OutputName[256];

		switch (argv[4][0]) {
		case '+':
			strcpy(OutputName,argv[1]);
			if (strrchr(OutputName,'.')) {
				strcpy(strrchr(OutputName,'.'),".videoedit");
			}
			Out = fopen(OutputName,"w");
			if (Out==NULL) {
				Out = stdout;
			}
			break;
		case '-':
			break;
		default:
			Out = fopen(argv[4],"w");
			if (Out==NULL) {
				Out = stdout;
			}
			break;
		}
	}

	if (CreateNorms()==0) return -1;

	GetIntervals();
	SetIntervalEnergy();

	float MaxSpeedup = 0.2;
	float SpeedFactor = 5;
	float MinFrames = 25;
	float MaxFrames = 125;
	float ReduceFactor = 0.9;
	float FrameReduceFactor = 0.9;

	if (argc>10) {
		sscanf(argv[4],"%f",&MaxSpeedup);
		sscanf(argv[5],"%f",&SpeedFactor);
		sscanf(argv[6],"%f",&MinFrames);
		sscanf(argv[7],"%f",&MaxFrames);
		sscanf(argv[8],"%f",&ReduceFactor);
		sscanf(argv[9],"%f",&FrameReduceFactor);
	}

	AdjustIntervalSpeedup(MaxSpeedup,MaxSpeedup,SpeedFactor,MinFrames,MaxFrames);

	for (int i = 1; i < ClusterCount; i++) {
		while (GetWorstInterval(i)!=-1)
		{
			RemoveInterval(GetWorstInterval(i));
			if (GetIntervalsTotalLength()<MaxOutputFrames) {
				break;
			}
		}
	}

	while (GetIntervalsTotalLength()>MaxOutputFrames) {
		SpeedFactor *= ReduceFactor;
		MaxFrames *= FrameReduceFactor;
		AdjustIntervalSpeedup(MaxSpeedup,MaxSpeedup,SpeedFactor,MinFrames,MaxFrames);
	}

	OutputIntervals(Out);

	if (Out!=stdout) {
		fclose(Out);
	}

	return 0;
}
//---------------------------------------------------------------------------
