// summ.cpp : Defines the entry point for the console application.

#include <cv.h>
#include <highgui.h>

#include "cvffmpeg/cvffmpeg.h"

#define AVFILE_USE_BMPFILE 0
#define AVFILE_USE_FFFILE 1 

void printHelp( void );

typedef struct CvAVI_VFW_Writer
{
//    PAVIFILE      avifile;
//    PAVISTREAM    compressed;
//    PAVISTREAM    uncompressed;
    double        fps;
    CvSize        frameSize;
    IplImage    * tempFrame;
    long          pos;
    int           fourcc;
} CvAVI_VFW_Writer;

FILE * fin;
char	* fileIn  = NULL,
	  fileOut[1024],
	* configTXT = NULL;

CvVideoWriter * videoOut = NULL; 
int show = 0;

int lineWidth = 7;

int main(int argc, char** argv)
{
	int pressed = 0;
	CvMat * showCH = 0, * showG = 0;
	CvMat	  frameIn,
		* frameOut =NULL;
	IplImage * imgOut = NULL;
	IplImage * imgIn = NULL;
	int frameNo = 0, frameCount;
	ffMedia *media = newMedia();

	__BEGIN__

	/* read parameters from command line */ 
	for( int i = 1; i < argc; ++i )
	{
		if     ( strcmp( argv[i], "-i")  == 0 && i < argc+1 ) fileIn  = argv[++i]; 
		else if( strcmp( argv[i], "-c")  == 0 && i < argc+1 ) configTXT = argv[++i]; 
		else if( strcmp( argv[i], "-s")  == 0 && i )		  show = 1; 
		else if( strcmp( argv[i], "-lw") == 0 && i < argc+1)  lineWidth = atoi( argv[++i] ); 
	}

	if( !fileIn || !configTXT ) { printf( "\nError: Input or configuration file is not specified.\n\n" ); printHelp(); EXIT; }
	{
		char *p = strrchr( fileIn, '\\' );
		if( !p ) p = strrchr( fileIn, '/' );
		if( !p ) p = fileIn;
		sprintf( fileOut, "%s", p+1 );
		p = strrchr( fileOut, '.' );
		if( p ) sprintf( p, ".sum.avi" );
	}

	/* Open input and output video. */
	{
		// open the media file
		if ( !ffOpenFile(media, fileIn) ) 
		{
			printf("Couldn't open file %s\n",fileIn);
			EXIT;
		}

		frameCount  = ffLength(media);
		frameIn   = cvMat( media->codecCtx->height, media->codecCtx->width, CV_8UC4, 0 );
		frameOut  = cvCreateMat( media->codecCtx->height, media->codecCtx->width, CV_8UC3 );

		videoOut = cvCreateVideoWriter( fileOut, CV_FOURCC( 'D', 'I', 'V', 'X' ), 25, cvSize( media->codecCtx->width, media->codecCtx->height ), 1 );
		//videoOut = cvCreateVideoWriter( fileOut, CV_FOURCC_DEFAULT, 25, cvSize( media->codecCtx->width, media->codecCtx->height ), 1 );
		//videoOut = cvCreateVideoWriter( fileOut, 1935959654, 25, cvSize( media->codecCtx->width, media->codecCtx->height ), 1 );
		//videoOut = cvCreateVideoWriter( "test.avi", -1, 25, cvSize( media->codecCtx->width, media->codecCtx->height ), 1 );

		if( !videoOut )
			{		printf( "Error: cannot open output video file.   \n" );EXIT;	}

			//printf( "\t           DIB  ... uncompressed (default)\n" );
			//printf( "\t           PIM1 ... MPEG-1 codec\n" );
			//printf( "\t           MJPG ... motion-jpeg codec (does not work well)\n" );
			//printf( "\t           MP42 ... MPEG-4.2 codec\n" );
			//printf( "\t           DIV3 ... MPEG-4.3 codec\n" );
			//printf( "\t           DIVX ... MPEG-4 codec\n" );
	}

	int rows, cols;
	CvMat * lineData, * lineImg;
	int fr0, fr1, clID;
	double speed;
	fin = fopen( configTXT, "rt" );
	if( !fin ) {		printf( "Error: cannot open input videoedit file.   \n" );EXIT;	}
	if( fscanf( fin, "%d %d", &rows, &cols ) != 2 ){ printf( "Error: videoedit header file reading failed.   \n" );EXIT;	}
	lineData = cvCreateMat( lineWidth, cols, CV_8UC3 );
	lineImg  = cvCreateMat( lineWidth, frameOut->cols, CV_8UC3 );
	imgOut   = cvCreateImage( cvSize( frameOut->cols, frameOut->rows ), IPL_DEPTH_8U, 3 );

	/* process descriptors on video frames */
	if( show ) cvNamedWindow( "Tmp", 1 );

	int line;line = 0;
	int sum0;sum0 = 0;
	int sum1;sum1 = 0;
	char key;key = 0;
	CvFont font;
	cvInitFont( &font, CV_FONT_HERSHEY_DUPLEX, 0.3, 0.3, 0, 1, CV_AA );
	while( line < rows )
	{
		if( !feof( fin ) && line < rows )
			if( fscanf( fin, "%d %d %d %lf", &fr0, &fr1, &clID, &speed ) != 4 )
				{ printf( "Error: videoedit sub-header file reading failed.   \n" );EXIT;	}

		for( int i = 0; i < cols; ++i ) 
		{
			int c;
			if( fscanf( fin, "%d", &c ) != 1 )
				{ printf( "Error: videoedit file data reading failed.   \n" );EXIT;	}
			if( c >= 0 ) cvSet2D( lineData, 0, i, cvScalar( 1.0 * c, 1.0 * c, 1.0 * c, 1.0 ) );
			else cvSet2D( lineData, 0, i, cvScalar( 0.0 * 255, 0.0 * 255, 1.0 * 255, 1.0 ) );
		}
		for( int i = 0; i < lineWidth; ++i )
		{
			CvMat r1, r2;
			cvCopy( cvGetSubRect( lineData, &r1, cvRect( 0, 0, cols, 1 ) ), cvGetSubRect( lineData, &r2, cvRect( 0, i, cols, 1 ) ), 0 );
		}
		cvResize( lineData, lineImg );
		
		int fr = cvFloor( speed * ( fr1 - fr0 ) );
		sum1 += fr;
		CvMat subr;

		printf( "[% 3d/% 3d] % 6d % 6d % 3d %f % 3d (%d, %d)\n", line, rows, fr0, fr1, fr1 - fr0, speed, fr, sum0, sum1 );

		for( int i = 0; i < fr; ++i )
		{

			if (ffAvFramePreciseSeek(media, cvFloor( fr0 + 1.0 * i / speed )) == NULL || media->ffEof)
			{
				printf("PreciseSeek failed to position: %u", cvFloor( fr0 + 1.0 * i / speed ) );
			}

			ffConvert(media, NULL);
			imgIn = media->sws->cvFrame;

      //naplnit sem
      //imgOut = media->ffFrame;

      //frameIn.data.ptr = (unsigned char *)media->ffFrame;

			//cvConvertScale( &frameIn, frameOut, -1.0, 256 );
			cvCvtColor( imgIn, imgOut, CV_BGRA2BGR );
      //cvCvtColor( &frameIn, imgOut, CV_GRAY2BGR);
			
      //cvCopy( &frameIn, frameOut );

			/* render line */ 
			cvCopy( lineImg, cvGetSubRect( imgOut, &subr, cvRect( 0, imgOut->height - lineImg->rows, imgOut->width, lineImg->rows ) ), 0 );

			/* render info */
			int infoboxW = 50, infoboxH = 13;
			cvGetSubRect( imgOut, &subr, cvRect( 2, imgOut->height - lineWidth - infoboxH, infoboxW, infoboxH ) );

			cvConvertScale( &subr, &subr, 0.5, 0 );

			char buff[1024];
			CvSize text_size;
			int baseline;
			sprintf( buff, "%4.2fx", 1.0/speed );
			cvGetTextSize( buff, &font, &text_size, &baseline );
			cvPutText( &subr, buff, cvPoint( (infoboxW-text_size.width)/2, 10 ), &font, CV_RGB( 255, 255, 255 ) );

			cvWriteFrame( videoOut, imgOut );

			if( show ) {
				cvShowImage( "Tmp", imgOut );
				if( ( key = cvWaitKey( 20 ) ) == 27 ) break;
			}

			sum0++;
		}
		if( key == 27 ) break;
		line++;
	}

	__END__

	if( videoOut )
		cvReleaseVideoWriter( &videoOut );

	return 0;
}

void printHelp( void )
{
  printf("summarization output rendered\ninputs are original NOT sumarized Video and videoedit file created using sequence utility\n\ncommandline arguments:\n -i <inputfile>\n -c <videoedit file>\n\nexample: summ -i video.mkv -c video.videoedit\n\n\n");
}
