%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Vstupn pravidla
% rules_output.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% definice poadi aplikace vstupnch pravidel
output_rule_order('o_basic').
output_rule_order('o_summarization_fadeX').
output_rule_order('o_virtual_cameras_zooming_moving').
output_rule_order('o_virtual_cameras_simple').
output_rule_order('o_pip_in_third_camera').
output_rule_order('o_pip_background_camera').
output_rule_order('o_perspective_cameras_simple').
%output_rule_order('o_logo1').
%output_rule_order('o_logo2').
output_rule_order('o_logo').
output_rule_order('o_summarization_fade_out').
output_rule_order('o_summarization_fade_in').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
output_rule(Name, Time, Camera, In, Out, _) :-
  output_rule(Name, Time, Camera, In, Out).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% zkladn pravidlo
output_rule(Name, _, Camera, _, Out) :-
  Name = 'o_basic',
  Out = [('Camera', Camera)].

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pechod pi sumarizaci
output_rule(Name, Time, _, In, Out) :-
  Name = 'o_summarization_fadeX',
  rule_configuration(Name, Duration),
  member(('Camera', Camera), In),
  pred_last_output(Time, Camera, C, L),
  L < Duration,

  (   Camera = -1
  ->
      Percent is 100 * (L / Duration),
      PercentBegin is Percent,
      step(Step),
      PercentEnd is min(100 * ((L + Step) / Duration), 100),
      delete(In, ('camera', Camera), Tmp1),
      append(Tmp1, [('camera', C), ('effect1', 'fade'), ('fadepercent', Percent), ('fadecolor', '0x00ffffff'),
		    ('audioeffect1', 'audiofade'), ('audiofadepercentbegin', PercentBegin), ('audiofadepercentend', PercentEnd)],
	     Out)
  ;   C = -1
  ->  Percent is 100 * ((Duration - L) / Duration),
      PercentBegin is Percent,
      step(Step),
      PercentEnd is max(100 * ((Duration - L - Step) / Duration), 0),
      append(In, [('effect1', 'fade'), ('fadepercent', Percent), ('fadecolor', '0x00ffffff'),
		  ('audioeffect1', 'audiofade'), ('audiofadepercentbegin', PercentBegin), ('audiofadepercentend', PercentEnd)], Out)
  ).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pechod pi sumarizaci
output_rule(Name, Time, _, In, Out) :-
	
  Name = 'o_summarization_fade_out',
  rule_configuration(Name, Duration),
  model_state(presentation),
  member(('Camera', Camera), In),
  pred_last_output_parameters(Time, Camera, C, L, Params),
  L < Duration,

  Camera = -1,
  Percent is 100 * (L / Duration),
  PercentBegin is Percent,
  step(Step),
  PercentEnd is min(100 * ((L + Step) / Duration), 100),
  append(Params, [('Effect', 'Fade1'), ('Fade1Percent', Percent), ('Fade1Color', '0x00ffffff'),
		  ('AudioEffect', 'AudioFade1'), ('AudioFade1PercentBegin', PercentBegin), ('AudioFade1Percentend', PercentEnd)], Out).
  
output_rule(Name, Time, _, In, Out) :-
  Name = 'o_summarization_fade_in',
  rule_configuration(Name, Duration),
  model_state(presentation),
  member(('Camera', Camera), In),
  not(is_empty_camera(Camera)),
  
  once((output(T1, C1, _), T1 < Time, is_empty_camera(C1))),
  
  (   once((output(T2, C2, _), T2 > T1, not(is_empty_camera(C2)), not((output(T3, _, _), T3 > T1, T3 < T2))))
  ->  L is Time - T2
  ;   L is 0
  ),
  
  L < Duration,
  
  Percent is 100 * ((Duration - L) / Duration),
  PercentBegin is Percent,
  step(Step),
  PercentEnd is max(100 * ((Duration - L - Step) / Duration), 0),
  append(In, [('Effect', 'Fade1'), ('Fade1Percent', Percent), ('Fade1Color', '0x00ffffff'),
	      ('AudioEffect', 'AudioFade1'), ('AudioFade1PercentBegin', PercentBegin), ('AudioFade1Percentend', PercentEnd)], Out)
  .


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% obraz v obraze ve tet kamee
output_rule(Name, Time, Camera, In, Out) :-
  Name = 'o_pip_in_third_camera',
  rule_configuration(Name),

  camera(Camera, _, _, _, _, Parent, _),
  Parent \== 3,

  pred_last_output(Time, Camera, C, _),
  C == 3,

  BasePosX is 0.2,
  findall(X, Person^Y^(person(Person), future_past_person_position(Time, Person, C, X, Y)), PersonX),
  PersonX \== [],
  camera(C, Width, _),
  (   forall(member(X, PersonX), X >= Width / 2)
  ->  PosX is BasePosX,
      Mirror = (Parent == 2)
  ;   forall(member(X, PersonX), X < Width / 2)
  ->  PosX is 1 - BasePosX,
      Mirror = (Parent == 1)
  ;   fail
  ),

  (   Mirror
  ->  append(In, [('effect3', 'hmirror')], Tmp1)
  ;   Tmp1 = In
  ),

  append(Tmp1, [('effect4', 'stack'), ('stackcamera', 1000000),
		('effect5', 'basic'), ('basiccamera', C),
		('effect6', 'pip'), ('pipcamera', 1000000), ('pipcenterx', PosX), ('pipcentery', '0.2'), ('pipratio', '0.4')],
	 Out).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% modulace rychlosti pechodu virtuln kamery
virtual_camera_position(I, P) :-
  P is 1 - (cos(I * pi) + 1) / 2.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
virtual_camera_percent(Parent, ID, Zoom, X, Y) :-
  virtual_camera(Parent, ID, Zoom, XP, YP),
  camera(Parent, Left, Top, Width, Height),
  X is XP / Width,
  Y is YP / Height.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
virtual_camera_percent_rel(Parent, ID, Zoom, X, Y) :-
  virtual_camera(Parent, ID, Zoom, XP, YP),
  camera(Parent, Left, Top, Width, Height),
  X is XP / Width,
  Y is YP / Height.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pechod virtulnch kamer
output_rule(Name, Time, _, In, Out) :-
  Name = 'o_virtual_cameras_zooming_moving',
  rule_configuration(Name, Duration, Zooming, Moving),
  member(('Camera', Camera), In),
  pred_last_output(Time, Camera, C, L),
  camera(Camera, _, _, _, _, Parent, ID),
%  write('c '), write(Camera), nl,

  (   L < Duration
  ->  (  camera(C, _, _, _, _, LastParent, LastID),
         (   (Camera \== Parent, C == LastParent, Parent == LastParent, Zooming \== 0)
	 ->  (  virtual_camera_percent(Parent, ID, VirtualZoom, VirtualCenterX, VirtualCenterY),
	        ParentCenterX is 0.5,
		ParentCenterY is 0.5,

		virtual_camera_position(L / Duration, I),
		Zoom is 1 + I * (VirtualZoom - 1),

		HI is (I * VirtualZoom) / (I * (VirtualZoom - 1) + 1),
		%HI is I,
		CenterX is (1 - HI) * ParentCenterX + HI * VirtualCenterX,
		CenterY is (1 - HI) * ParentCenterY + HI * VirtualCenterY,

		delete(In, ('Camera', Camera), Out1),
		append(Out1, [('Camera', Parent), ('effect2', 'zoom'), ('zoomratio', Zoom), ('zoomcenterx', CenterX), ('zoomcentery', CenterY)], 
		       Out)
	     )
	 ;   (   (Camera == Parent, C \== LastParent, Camera == LastParent, Zooming \== 0) 
	     ->  (  virtual_camera_percent(LastParent, LastID, VirtualZoom, VirtualCenterX, VirtualCenterY),
		    ParentCenterX is 0.5,
		    ParentCenterY is 0.5,
    
		    virtual_camera_position(1 - L / Duration, I),
		    Zoom is 1 + I * (VirtualZoom - 1),

		    HI is (I * VirtualZoom) / (I * (VirtualZoom - 1) + 1),
		    %HI is I,
		    CenterX is (1 - HI) * ParentCenterX + HI * VirtualCenterX,
		    CenterY is (1 - HI) * ParentCenterY + HI * VirtualCenterY,
 
		    append(In, [('effect2', 'zoom'), ('zoomratio', Zoom), ('zoomcenterx', CenterX), ('zoomcentery', CenterY)], Out)
		 )
	     ;  (   (Camera \== Parent, C \== LastParent, Parent == LastParent, Camera \== C, Moving \== 0) 
		->  (  virtual_camera_percent(Parent, ID, VirtualZoom, VirtualCenterX, VirtualCenterY),
		       virtual_camera_percent(LastParent, LastID, LastVirtualZoom, LastVirtualCenterX, LastVirtualCenterY),

		       virtual_camera_position(L / Duration, I),
		       Zoom is (1 - I) * LastVirtualZoom + I * VirtualZoom,
		       CenterX is (1 - I) * LastVirtualCenterX + I * VirtualCenterX,
		       CenterY is (1 - I) * LastVirtualCenterY + I * VirtualCenterY,

		       delete(In, ('Camera', Camera), Out1),
		       append(Out1, [('Camera', Parent), ('effect2', 'zoom'), ('zoomratio', Zoom), ('zoomcenterx', CenterX), ('zoomcentery', CenterY)], Out)
		    )
		;  (  Camera \== Parent,
		      virtual_camera_percent(Parent, ID, Zoom, CenterX, CenterY),
		      delete(In, ('Camera', Camera), Out1),
		      append(Out1, [('Camera', Parent), ('effect2', 'zoom'), ('zoomratio', Zoom), ('zoomcenterx', CenterX), ('zoomcentery', CenterY)], Out)
		   )
		)
	     )
	 )
      )
  ;  (  Camera \== Parent,
        virtual_camera_percent(Parent, ID, Zoom, CenterX, CenterY),
	delete(In, ('Camera', Camera), Out1),
	append(Out1, [('Camera', Parent), ('effect2', 'zoom'), ('zoomratio', Zoom), ('zoomcenterx', CenterX), ('zoomcentery', CenterY)], Out)
     )
  ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pm pepnut virtulnch kamer
output_rule(Name, _, _, In, Out) :-
	Name = 'o_virtual_cameras_simple',
	rule_configuration(Name),
	member(('Camera', Camera), In),
	camera(Camera, _, _, _, _, Parent, ID),
	Camera \== Parent,
	not(perspective_virtual_camera(Camera, _, _, _, _, _, _, _, _, _)),
	virtual_camera_percent_rel(Parent, ID, Zoom, CenterX, CenterY),
	(   virtual_camera_size(Parent, ID, HorizontalSize, VerticalSize) ->
	    (L is (1 - HorizontalSize) / 2, 
	     T is (1 - VerticalSize) / 2, 
	     R is 1 - L,
	     B is 1 - T,
	     delete(In, ('Camera', Camera), Out1),
	     append(Out1, [('Camera', Parent), ('EffectVCS1', 'ZoomVCS1'), ('ZoomVCS1Ratio', Zoom), ('ZoomVCS1CenterX', CenterX), ('ZoomVCS1CenterY', CenterY), 
			   ('EffectVCS2', 'CropVCS2'), ('CropVCS2Left', L), ('CropVCS2Top', T), ('CropVCS2Right', R), ('CropVCS2Bottom', B)], Out)
	    )
	;   
	     (delete(In, ('Camera', Camera), Out1),
	      append(Out1, [('Camera', Parent), ('EffectVCS1', 'ZoomVCS1'), ('ZoomVCS1Ratio', Zoom), ('ZoomVCS1CenterX', CenterX), ('ZoomVCS1CenterY', CenterY)], Out)
	    )
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zobrazeni podkladove kamery (kamera s druhou nejvetsi vahou)
output_rule(Name, _, _, In, Out, Cameras) :-
       %write(In), write(' '), 
%	write(Cameras), nl, 
  
  model_state(presentation),
  Name = 'o_pip_background_camera',
  rule_configuration(Name, Background, PosX1, PosY1, RatioX1, RatioY1, PosX2, PosY2, RatioX2, RatioY2),
  member((Background, _), Cameras),
 
  % predelat!
  not((member((CC, _), Cameras), (is_empty_camera(CC); CC == 3; CC = 4))),
  
  member(('Camera', Camera), In),
  Camera >= 0,
  perspective_virtual_camera(Background, X1, Y1, X2, Y2, X3, Y3, X4, Y4, _),
  parent_camera(Background, Parent),
  camera(Parent, PW, PH),
  RX1 is X1 / PW,
  RY1 is Y1 / PH,
  RX2 is X2 / PW,
  RY2 is Y2 / PH,
  RX3 is X3 / PW,
  RY3 is Y3 / PH,
  RX4 is X4 / PW,
  RY4 is Y4 / PH,
  append(In, [('EffectPBC1', 'StackPBC1'), ('StackPBC1Camera', 1000000),
	      ('EffectPBC2', 'BasicPBC2'), ('BasicPBC2Camera', Parent),
   	      ('EffectPBC3', 'PerspectivePBC3'), ('PerspectivePBC3X1', RX1), ('PerspectivePBC3Y1', RY1), ('PerspectivePBC3X2', RX2), ('PerspectivePBC3Y2', RY2), ('PerspectivePBC3X3', RX3), ('PerspectivePBC3Y3', RY3), ('PerspectivePBC3X4', RX4), ('PerspectivePBC3Y4', RY4),
	      ('EffectPBC4', 'StackPBC4'), ('StackPBC4Camera', 1000001),
	      ('EffectPBC5', 'BasicPBC5'), ('BasicPBC5Camera', 1000002),
	      ('EffectPBC6', 'PIPPBC6'), ('PIPPBC6Camera', 1000001), ('PIPPBC6CenterX', PosX1), ('PIPPBC6CenterY', PosY1), ('PIPPBC6RatioX', RatioX1), ('PIPPBC6RatioY', RatioY1),
	      ('EffectPBC7', 'PIPPBC7'), ('PIPPBC7Camera', 1000000), ('PIPPBC7CenterX', PosX2), ('PIPPBC7CenterY', PosY2), ('PIPPBC7RatioX', RatioX2), ('PIPPBC7RatioY', RatioY2)],
	 Out).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zobrazeni loga
output_rule(Name, _, _, In, Out, _) :-
  Name = 'o_logo1',
  rule_configuration(Name, LogoCamera, PosX, PosY, RatioX, RatioY),
  member(('Camera', Camera), In),  
  not(is_empty_camera(Camera)),
  model_state(presentation),
  append(In, [('EffectL1', 'PIPL1'), ('PIPL1Camera', LogoCamera), ('PIPL1CenterX', PosX), ('PIPL1CenterY', PosY), ('PIPL1RatioX', RatioX), ('PIPL1RatioY', RatioY), ('PIPL1Transparent', 1)],
	 Out).

output_rule(Name, _, _, In, Out, _) :-
  Name = 'o_logo2',
  rule_configuration(Name, LogoCamera, PosX, PosY, RatioX, RatioY),
  member(('Camera', Camera), In),  
  not(is_empty_camera(Camera)),
  model_state(presentation),
  append(In, [('EffectL2', 'PIPL2'), ('PIPL2Camera', LogoCamera), ('PIPL2CenterX', PosX), ('PIPL2CenterY', PosY), ('PIPL2RatioX', RatioX), ('PIPL2RatioY', RatioY), ('PIPL2Transparent', 1)],
	 Out).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zobrazeni loga
output_rule(Name, _, _, In, Out, _) :-
  Name = 'o_logo',
  model_state(presentation),
  member(('Camera', Camera), In),
  not(is_empty_camera(Camera)),
  bagof((LogoCamera, PosX, PosY, RatioX, RatioY), LogoCamera^PosX^PosY^RatioX^RatioY^rule_configuration(Name, LogoCamera, PosX, PosY, RatioX, RatioY), List),
  output_rule_logo(In, Out, List, 1).

output_rule_logo(InOut, InOut, [], _).
output_rule_logo(In, Out, [H|T], N) :-
  (LogoCamera, PosX, PosY, RatioX, RatioY) = H,
  string_concat('EffectL', N, Effect),
  string_concat('PIPL', N, Prefix),
  string_concat(Prefix, 'Camera', PrefixCamera),
  string_concat(Prefix, 'CenterX', PrefixCenterX),
  string_concat(Prefix, 'CenterY', PrefixCenterY),
  string_concat(Prefix, 'RatioX', PrefixRatioX),
  string_concat(Prefix, 'RatioY', PrefixRatioY),
  string_concat(Prefix, 'Transparent', PrefixTransparent),
  append(In, [(Effect, Prefix), (PrefixCamera, LogoCamera), (PrefixCenterX, PosX), (PrefixCenterY, PosY), (PrefixRatioX, RatioX), (PrefixRatioY, RatioY), (PrefixTransparent, 1)],
	 Tmp),
  N2 is N + 1,
  output_rule_logo(Tmp, Out, T, N2).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pm pepnut perspektivni kamery
output_rule(Name, _, _, In, Out) :-
	Name = 'o_perspective_cameras_simple',
	rule_configuration(Name),
	member(('Camera', Camera), In),
	camera(Camera, _, _, _, _, Parent, ID),
	Camera \== Parent,
	perspective_virtual_camera(Camera, X1, Y1, X2, Y2, X3, Y3, X4, Y4, Ratio),

  parent_camera(Camera, Parent),
  camera(Parent, PW, PH),
  RX1 is X1 / PW,
  RY1 is Y1 / PH,
  RX2 is X2 / PW,
  RY2 is Y2 / PH,
  RX3 is X3 / PW,
  RY3 is Y3 / PH,
  RX4 is X4 / PW,
  RY4 is Y4 / PH,

  delete(In, ('Camera', Camera), Out1),
  
  append(Out1, [('Camera', Parent), ('EffectPCS1', 'PerspectivePCS1'), ('PerspectivePCS1X1', RX1), ('PerspectivePCS1Y1', RY1), ('PerspectivePCS1X2', RX2), ('PerspectivePCS1Y2', RY2), ('PerspectivePCS1X3', RX3), ('PerspectivePCS1Y3', RY3), ('PerspectivePCS1X4', RX4), ('PerspectivePCS1Y4', RY4), ('PerspectivePCS1AspectRatio', Ratio)],
	 Out).
