%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Uren ustnk
% persons.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
init_persons:-
  (   test_mode([offline, half_realtime]) 
  ->  ignore(generate_all_persons)
  ;   true
  ),
  update_person_count.
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
update_person_count :-
  retractall(person_count(_)),
  findall(P, person(P), L),
  length(L, Count),
  assert(person_count(Count)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
generate_all_persons:-
  write_begin('generating persons'),
  retractall(person(_)),
  (setof(Person, Time^start_speaking(Time, Person), S1); S1	= []),
  (setof(Person, Time^stop_speaking(Time, Person), S2); S2 = []),
  (setof(Person, Time^Camera^Object^hand(Time, Camera, Object, Person), S3); S3 = []),
  (setof(Person, Time^Camera^head(Time, Camera, Person), S4); S4 = []),
  union(S1, S2, S12),
  union(S3, S4, S34),
  union(S12, S34, S),
  forall(member(Elem, S), assert(person(Elem))),
  write_done.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zjitn stavu astnka
person_movement(Time, Person, State) :-
  movement(T1, Person, State), 
  T1 =< Time,
  not((movement(T2, Person, _), T2 =< Time, T2 > T1)).
