%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Historie vbru kamer
% history.pl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
init_history :-
  retractall(output(_, _, _)),
  retractall(outputz(_, _, _)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zjitn pedchoz vybran kamery
last_output_parameters(Time, Camera, Parameters):-
  once((output(T, Camera, Parameters), T =< Time)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
last_output_parameters(Time, Camera, HowLong, Parameters):-
  once((output(T1, Camera, Parameters), T1 =< Time)),
  (once((output(T3, C3, _), T3 =< T1, C3 \= Camera)) -> true; T3 is -1000000),
  findall(T2, T2^P2^(output(T2, Camera, P2), T2 > T3, T2 =< T1), L),
  last(L, FT),
  HowLong is Time - FT.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
last_output(Time, Camera):-
  last_output_parameters(Time, Camera, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
last_output(Time, Camera, HowLong):-
  last_output_parameters(Time, Camera, HowLong, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zjitn kamery ped pedchoz kamerou
pred_last_output(Time, LastCamera, PredCamera, HowLong):-
  once((output(T1, Camera, _), T1 =< Time)),
  ((Camera \= LastCamera) ->
  (PredCamera = Camera, HowLong is 0);
  ((once((output(T3, PredCamera, _), T3 =< T1, PredCamera \= Camera)) ->
   (findall(T2, T2^P2^(output(T2, Camera, P2), T2 > T3, T2 =< T1), L),
    last(L, FT),
    HowLong is Time - FT
   ); fail)
  )).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% zjitn kamery ped pedchoz kamerou
pred_last_output_parameters(Time, LastCamera, PredCamera, HowLong, Params):-
  once((output(T1, Camera, P1), T1 =< Time)),
  ((Camera \= LastCamera) ->
  (PredCamera = Camera, HowLong is 0, Params = P1);
  ((once((output(T3, PredCamera, _), T3 =< T1, PredCamera \= Camera)) ->
   (findall(T2, T2^P2^(output(T2, Camera, P2), T2 > T3, T2 =< T1), L),
    last(L, FT),
    output(T3, PredCamera, Params),
    HowLong is Time - FT
   ); fail)
  )).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
update_last_output_optimized(Time) :-
  retractall(last_output_actual(_, _, _)),
  ignore((last_output(Time, Camera, HowLong), 
	  assert(last_output_actual(Time, Camera, HowLong)))).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
last_output_optimized(Time, Camera, HowLong) :-
  last_output_actual(Time, Camera, HowLong) -> true;
  last_output(Time, Camera, HowLong).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
last_output_optimized(Time, Camera) :-
  last_output_actual(Time, Camera, _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
last_output_parametersX(Time, Camera, Parameters):-
  findall((T, C), (output(T, C, _), T =< Time), X),
  sort(X, Y),
  last(Y, (LastTime, Camera)),
  output(LastTime, Camera, Parameters).

sooner_same_camera(Camera, [Head|Tail], Time, Index) :-
  (T, C) = Head,
  ((C = Camera) -> 
  (sooner_same_camera(Camera, Tail, Time2, Index2) -> 
  (Time = Time2, Index is Index2 + 1); 
  (Time = T, Index is 0))).

last_output_parametersX(Time, Camera, HowLong, Parameters):-
  findall((T, C), (output(T, C, _), T =< Time), X),
  sort(X, Y),
  reverse(Y, Z),
  nth0(0, Z, (LastTime, Camera)),
  output(LastTime, Camera, Parameters),
  sooner_same_camera(Camera, Z, FT, _),
  HowLong is Time - FT.

%last_output_parameters(Time, Camera, HowLong, Parameters):-
%  findall(T1, (output(T1, Camera, _), 
%	       T1 =< Time, not((output(T2, LaterCamera, _), T2 =< Time,
%	       T2 > T1, LaterCamera \= Camera)) ), X), minlist(X,
%	       MinTime), maxlist(X, MaxTime), output(MaxTime, Camera,
%	       Parameters), HowLong is Time - MinTime.

%last_output_parameters(Time, Camera, Parameters):-
%  output(T1, Camera, Parameters), 
%  T1 =< Time,
%  not((output(T2, _, _), T2 =< Time, T2 > T1)).


pred_last_outputX(Time, LastCamera, PredCamera, HowLong):-
  findall((T, C), (output(T, C, _), T =< Time), X),
  sort(X, Y),
  reverse(Y, Z),
  nth0(0, Z, (_, Camera)),
  ((Camera \= LastCamera) -> 
  (PredCamera = Camera, HowLong is 0);
  (sooner_same_camera(Camera, Z, FT, Index),
   HowLong is Time - FT,
   I is Index + 1,
   nth0(I, Z, (_, PredCamera)))).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

last_output_parametersXX(Time, Camera, HowLong, Parameters):-
  once((output(T1, Camera, Parameters), T1 =< Time)),
  (once((output(T3, C3, _), T3 =< T1, C3 \= Camera)) -> true; T3 is -1000000),
  once((outputz(T2, Camera, _), T2 > T3, T2 =< T1)),
  HowLong is Time - T2.
