%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
custom_init :-
	write_begin('import esf'),
	ignore(import_esf),
	write_done.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
custom_real_time_generate(Time) :-
	test_mode([realtime]),
	ignore(generate_esf_heads(Time)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
import_esf :-
	retractall(head(_, _, _, _, _, _, _, _, _, _)),
	assert(person(a)),
	retractall(person(_)),
	assert(tmp_last_time(a, 0)),
	retractall(tmp_last_time(_, _)),
	begin(B),
	end(E),
	step(S),
	ignore(generate_esf_heads_step(B, E, S)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
generate_esf_heads_step(Time, End, Step) :-
	(   Time =< End
	->  ignore(generate_esf_heads(Time)),
	    T is Time + Step,
	    generate_esf_heads_step(T, End, Step)
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% osobu odvodit z kamery a objektu
generate_esf_heads(Time) :-
	MinSize is 1500,
	step(S),
	forall((teacher(Time, Camera, Object, CenterX, CenterY, DivergenceX, DivergenceY, Size), Size >= MinSize),
	       (Person = a,
		assert(head(Time, Camera, Object, CenterX, CenterY, CenterX, CenterY, CenterX, CenterY, Person)),
		
		(   not(person(Person))
		->  assert(person(Person)),
                    update_person_count
		;   true
		)
				
	       )
	      ),
	Time0 is Time - S,
	forall((head(Time0, Camera, Object, CenterX, CenterY, CenterX, CenterY, CenterX, CenterY, Person),
	       not(head(Time, Camera, Object, _, _, _, _, _, _, Person))),
	       assert(head(Time, Camera, Object, CenterX, CenterY, CenterX, CenterY, CenterX, CenterY, Person))
	      ).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
esf_heads_step(Time, End, Step, Camera, Object, CenterX, CenterY, Person) :- 
	(   Time =< End
	->  assert(head(Time, Camera, Object, CenterX, CenterY, CenterX, CenterY, CenterX, CenterY, Person)),
	    T is Time + Step,
	    esf_heads_step(T, End, Step, Camera, Object, CenterX, CenterY, Person)
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
import_esf2 :-
  retractall(head(_, _, _, _, _, _, _, _, _, _)),
  setof((Camera, Object), T^CenterX^CenterY^DivergenceX^DivergenceY^Size^teacher(T, Camera, Object, CenterX, CenterY, DivergenceX, DivergenceY, Size), Objects),
  forall(member((Camera, Object), Objects), generate_esf_heads(Camera, Object)).      

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
generate_esf_heads2(Camera, Object) :-
  MinSize is 1000,
  step(S),
  forall((teacher(Time, Camera, Object, CenterX, CenterY, DivergenceX, DivergenceY, Size), Size >= MinSize),
	 ((tmp_last_time(LastTime) -> true; LastTime is 0),
	  T1 is (Time // S) * S,
	  %Y is CenterY - DivergenceY,
	  Y is CenterY,
	  ignore(esf_heads_step(LastTime, T1, S, Camera, Object, CenterX, Y)),
	  retractall(tmp_last_time(_)),
	  assert(tmp_last_time(T1))
	 )
	).

