//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef WaveH
#define WaveH

//---------------------------------------------------------------------------
#include "avfile.h"

//---------------------------------------------------------------------------
class TWave
{
private:
	bool Allocated;

public:
	BYTE *Wave;
	int Channels, SamplesPerSec;
	unsigned int Size;

	TWave();
	TWave(int _Channels, int _SamplesPerSec);
	TWave(int _Channels, int _SamplesPerSec, unsigned int _Size, BYTE *_Wave, bool _Allocate = false);
	~TWave();

	void Assign(TWave &Wave);
	void Clear();
	void Create(int _Channels, int _SamplesPerSec, unsigned int _Size, BYTE *_Wave, bool _Allocate = false);
	void Free();
};

#endif

