//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "Wave.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TWave::TWave()
{
	Wave = NULL;
	Channels = SamplesPerSec = Size = 0;
	Allocated = false;
}

//---------------------------------------------------------------------------
TWave::~TWave()
{
	Free();
}

//---------------------------------------------------------------------------
TWave::TWave(int _Channels, int _SamplesPerSec)
{
	Wave = NULL;
	Size = 0;
	Channels = _Channels;
	SamplesPerSec = _SamplesPerSec;
	Allocated = false;
}

//---------------------------------------------------------------------------
TWave::TWave(int _Channels, int _SamplesPerSec, unsigned int _Size, BYTE *_Wave, bool _Allocate)
{
	Wave = NULL;
	Channels = SamplesPerSec = Size = 0;
	Allocated = false;
	Create(_Channels, _SamplesPerSec, _Size, _Wave, _Allocate);
}

//---------------------------------------------------------------------------
void TWave::Create(int _Channels, int _SamplesPerSec, unsigned int _Size, BYTE *_Wave, bool _Allocate)
{
	Free();
	if (_Allocate)
	{
		Wave = new BYTE[_Size];
		if (_Size > 0)
		{
			memcpy(Wave, _Wave, _Size);
		}
	}
	else
	{
		Wave = _Wave;
	}
	Channels = _Channels;
	SamplesPerSec = _SamplesPerSec;
	Size = _Size;
	Allocated = _Allocate;
}

//---------------------------------------------------------------------------
void TWave::Free()
{
	if (Wave && Allocated)
	{
		delete[] Wave;
	}
	Wave = NULL;
	Channels = SamplesPerSec = Size = 0;
	Allocated = false;
}

//---------------------------------------------------------------------------
void TWave::Assign(TWave &Wave)
{
	Create(Wave.Channels, Wave.SamplesPerSec, Wave.Size, Wave.Wave, true);
}

//---------------------------------------------------------------------------
void TWave::Clear()
{
	if (Wave && Allocated)
	{
		delete[] Wave;
	}
	Wave = NULL;
	Size = 0;
	Allocated = false;
}

