//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "VideoStack.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TVideoStack::~TVideoStack()
{
	Clear();
}

//---------------------------------------------------------------------------
void TVideoStack::Insert(int Camera, TImg* Img)
{
	TStack::iterator i = Stack.find(Camera);
	if (i != Stack.end())
	{
		delete i->second;
		Stack.erase(i);
	}
	Stack[Camera] = Img;
}

//---------------------------------------------------------------------------
TImg* TVideoStack::Get(int Camera)
{
	TStack::iterator i = Stack.find(Camera);
	if (i != Stack.end())
	{
		return i->second;
	}
	else
	{
		return NULL;
	}
}

//---------------------------------------------------------------------------
void TVideoStack::Clear()
{
	TStack::iterator i = Stack.begin();
	while (i != Stack.end())
	{
		delete i->second;
		i++;
	}
	Stack.clear();
}

