//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef SourcesH
#define SourcesH

//---------------------------------------------------------------------------
#include <vector>
#include "ImpExp.h"
#include "Img.h"
#include "Wave.h"

//---------------------------------------------------------------------------
class TAVFile;

//---------------------------------------------------------------------------
class TExtendedSource: public TImpExp::TSource
{
public:
	class TBuffer
	{
	public:
		TImg *Img;
		TWave *Wave;
	};
	typedef std::vector<TBuffer> TBuffers;

	TAVFile *AVFile;

	unsigned int AudioWrittenSamples;
	unsigned int AudioBufferSize;
	BYTE *AudioBuffer;

	TBuffers Buffers;

	TExtendedSource();
	~TExtendedSource();

	void AllocBuffers(unsigned int Size);
	void ClearBuffers();
};

//---------------------------------------------------------------------------
class TExtendedSources
{
public:
	typedef std::vector<TExtendedSource*> TPSources;
	enum EResize {rOriginal, rHalf, rQuarter};
	TPSources Sources;

private:
	int Time;
	unsigned int Delay, Actual;
	EResize Resize;

	void ReadActualFrame(TPSources::iterator i);
	void SkipActualFrame(TPSources::iterator i);
	TPSources::iterator FindSource(int Camera);
	void ResizeDimension(unsigned int SrcWidth, unsigned int SrcHeight, unsigned int &DstWidth, unsigned int &DstHeight);
	void ResizeBitmap(unsigned int SrcWidth, unsigned int SrcHeight, unsigned int DstWidth, unsigned int DstHeight, BYTE *Src, BYTE *Dst);

public:
	TExtendedSources();
	~TExtendedSources();

	void push_back(TExtendedSource *Source);
	void clear();
	unsigned int size();
	TExtendedSource* operator[](unsigned int Index);

	void Init(unsigned int Delay = 0, EResize Resize = rOriginal);
	unsigned int GetDelay();
	void SetTime(int Time);
	TImg* GetFrame(int Camera, int Number = 0) { return GetFirstFrame(Camera, Number); };
	void SkipFrame();
	TImg* GetFirstFrame(int Camera, int Number = 0);
	TImg* GetLastFrame(int Camera, int Number = 0);
	TWave* GetAudio(unsigned int Source);
	unsigned int GetLength();

	bool GetFrameSize(unsigned int &Width, unsigned int &Height);
	bool GetAudioPrms(unsigned int &Channels, unsigned int &SamplesPerSec);

	EResize GetResize() { return Resize; };
	bool Eof();
};

#endif

