//---------------------------------------------------------------------------
#ifndef RTEditorH
#define RTEditorH

//---------------------------------------------------------------------------
#include <time.h>
#include <queue>
#include <vector>
#include "Editor.h"
#include "avfile.h"
#include "ComplexDetector.h"

//---------------------------------------------------------------------------
class PlEngine;

//---------------------------------------------------------------------------
class TRTEditor: public TEditor
{
public:
	enum TControlType
	{
		ctCConst,
		ctPConst,
		ctPMult
	};

	class TFloatControl
	{
	public:
		AnsiString Name;
		float Value;
		TFloatControl(AnsiString Name): Value(0)
		{ this->Name = Name; };
	};

	typedef std::vector<TFloatControl> TFloatControls;

	enum TMode
	{
		mAuto,
		mHalfRT,
		mRT,
		mRTF,
		mOutput
	};

	class TStatistics
	{
	public:
		int Sources, Import, Prolog, Editing, Total;
		TStatistics()
		{ Clear(); };
		void Clear()
		{ Sources = Import = Prolog = Editing = Total = 0; }
	};

private:
	TMode FMode;
	bool FInitiallized;
	int FTime, FStep;
	int FDetectorsDelay;
	bool FImport;
	ee::TEvents::iterator FItem;
	bool FHasVideo, FHasAudio;
	bool FNewVideo, FNewAudio;
	unsigned int FWidth, FHeight, FChannels, FSamplesPerSec, FOutputWidth, FOutputHeight;

	std::queue<TImg*> FVideo;
	std::queue<TWave*> FAudio;

	TStrings *FTexts;
	TStrings *FPrologSources;

	PlEngine *FProlog;

	TStatistics FStatistics;

	std::vector<TComplexDetector*> FDetectors;
	TImpExp FDetectorsImpExp;

	void DetectorsCreate();
	void DetectorsFree();
	void DetectorsInit(int MaxQueueSize);
	void DetectorsBreak();

	char *argv[10];

	bool UseOnlineCameras;

public:
	TRTEditor();
	~TRTEditor();

	void Init(TMode AMode = mAuto, int AStep = -1, int AEditingDelay = 0, int ADetectorsDelay = 0, bool AVideo = true, bool AAudio = true, TExtendedSources::EResize AResizeInput = TExtendedSources::rOriginal, TExtendedSources::EResize AResizeOutput = TExtendedSources::rOriginal);
	void Do(bool ASkipVideo = false, bool ASkipAudio = false, bool ASkipProlog = false);
	void Reset(int AEditingDelay = 0, int ADetectorsDelay = 0);

	bool HasVideo()
	{ return FHasVideo; };
	bool HasAudio()
	{ return FHasAudio; };
	int GetStep()
	{ return FStep; };

	void SetUseOnlineCameras(bool value)
	{ UseOnlineCameras = value; }

	TAVFile::TFrameInfo GetFrameInfo();
	TAVFile::TAudioInfo GetAudioInfo();

	TImg* GetVideo();
	TWave* GetAudio();

	void SetTexts(TStrings *ATexts)
	{ FTexts = ATexts; };
	void SetPrologSources(TStrings *APrologSources)
	{ FPrologSources->Assign(APrologSources); };

	int GetTime()
	{ return FTime; };
	void SetTime(int ATime)
	{ FTime = ATime; };
	void SkipVideo();
	void SkipAudio();
	void ClearQueues();

	unsigned int GetVideoQueueLength();

	TFloatControls GetControls(TControlType Type);
	void SetControl(TControlType Type, TFloatControl Control);

	TStatistics GetStatistics()
	{ return FStatistics; };
};

#endif

