//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef WindowsMMH
#define WindowsMMH

//---------------------------------------------------------------------------
#ifdef __BORLANDC__
#include <vcl.h>
#include <SyncObjs.hpp>
#endif
#include <vector>
#include "CustomMM.h"

//---------------------------------------------------------------------------
class TWindowsMM: public TCustomMM
{
private:
#ifdef __BORLANDC__
	TCriticalSection *CS;
#endif
	class TBlock
	{
	public:
		void *Address;
		size_t Size;
	};
	typedef std::vector<TBlock> TBlocks;

	TBlocks FreeBlocks, UsedBlocks;

public:
	TWindowsMM();
	virtual ~TWindowsMM();

	virtual void* GetMem(size_t Size);
	virtual void FreeMem(void *Mem);
	virtual void GC();
};

#endif

