//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdio.h>
#include <stdarg.h>
#include <SysUtils.hpp>
#pragma hdrstop
#include "Logging.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

static AnsiString Path;

//---------------------------------------------------------------------------
void InitLog()
{
	Path = ExtractFilePath(Application->ExeName) + "\\Logs\\" + FormatDateTime("yy-mm-dd hh-nn-ss", Now());
	ForceDirectories(Path);
}

//---------------------------------------------------------------------------
void Log(const char *Source, const char *Message, ...)
{
#ifdef LOG
	char buffer[1024];
	va_list ap;
	va_start(ap, Message);
	FILE *f = fopen((Path + "\\" + AnsiString(Source) + ".log").c_str(), "a");
	if (f)
	{
		vfprintf(f, Message, ap);
		fprintf(f, "\n");
		fclose(f);
	}
	va_end(ap);
#endif
}

