//---------------------------------------------------------------------------
#ifndef ImgToolsH
#define ImgToolsH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
inline int Bilinear(const BYTE *InputImage, int Width, int Height, int LineWidth, float X, float Y)
{
	// pozor !! osetrit meze, protoze bereme i barvu 4 okolnich pixelu
	int divYY, divXX, divYX, divXY,x1,x2,y1,y2;

	if (X < 1)
	{
		X = 1;
	}
	if (Y < 1)
	{
		Y = 1;
	}

	if (Y > Height - 2)
	{
		Y = Height - 2;
	}
	if (X > Width - 2)
	{
		X = Width - 2;
	}

	int x = X * 256;
	int y = Y * 256;

	int centX=(((int)X)<<8)+(128);	 // x + 0.5
	int centY=(((int)Y)<<8)+(128);	 // y + 0.5
	x1=centX-(x-(128));
	x2=x+(128)-centX;
	y1=centY-(y-(128));
	y2=y+(128)-centY;
	divXX=x1*y1;
	divYY=x2*y2;
	divYX=x1*y2;
	divXY=x2*y1;

	int pos=int(Y)*LineWidth+int(X)*4;
	unsigned char *data = (unsigned char *)InputImage + pos;

	int r, g, b, a;
	r = *data*divXX+*(data+4+LineWidth)*divYY+*(data+4)*divXY+*(data+LineWidth)*divYX;
	g = *(data+1)*divXX+*(data+1+4+LineWidth)*divYY+*(data+1+4)*divXY+*(data+1+LineWidth)*divYX;
	b = *(data+2)*divXX+*(data+2+4+LineWidth)*divYY+*(data+2+4)*divXY+*(data+2+LineWidth)*divYX;
	a = *(data+3)*divXX+*(data+3+4+LineWidth)*divYY+*(data+3+4)*divXY+*(data+3+LineWidth)*divYX;

	return (r & 0xff0000) >> 16 | (g & 0xff0000) >> 8 | (b & 0xff0000) | (a & 0xff0000) << 8;
}

//---------------------------------------------------------------------------
#define BilinearMakro(InputImage, Width, Height, LineWidth, X, Y, Result)\
{\
	int __divYY, __divXX, __divYX, __divXY, __x1, __x2, __y1, __y2;\
	float __X = X, __Y = Y;\
\
	if (__X < 1)\
		__X = 1;\
	if (__Y < 1)\
		__Y = 1;\
\
	if (__Y > Height - 2)\
		__Y = Height - 2;\
	if (__X > Width - 2)\
		__X = Width - 2;\
\
	int __x = __X * 256;\
	int __y = __Y * 256;\
\
	int __centX=(((int)__X)<<8)+(128);\
	int __centY=(((int)__Y)<<8)+(128);\
	__x1=__centX-(__x-(128));\
	__x2=__x+(128)-__centX;\
	__y1=__centY-(__y-(128));\
	__y2=__y+(128)-__centY;\
	__divXX=__x1*__y1;\
	__divYY=__x2*__y2;\
	__divYX=__x1*__y2;\
	__divXY=__x2*__y1;\
\
	int __pos=int(__Y) * LineWidth + int(__X)*4;\
	unsigned char *__data = (unsigned char *)InputImage + __pos;\
\
	int __r, __g, __b, __a;\
	__r = *__data*__divXX+*(__data+4+LineWidth)*__divYY+*(__data+4)*__divXY+*(__data+LineWidth)*__divYX;\
	__g = *(__data+1)*__divXX+*(__data+1+4+LineWidth)*__divYY+*(__data+1+4)*__divXY+*(__data+1+LineWidth)*__divYX;\
	__b = *(__data+2)*__divXX+*(__data+2+4+LineWidth)*__divYY+*(__data+2+4)*__divXY+*(__data+2+LineWidth)*__divYX;\
	__a = *(__data+3)*__divXX+*(__data+3+4+LineWidth)*__divYY+*(__data+3+4)*__divXY+*(__data+3+LineWidth)*__divYX;\
\
	*(Result) = (__r & 0xff0000) >> 16 | (__g & 0xff0000) >> 8 | (__b & 0xff0000) | (__a & 0xff0000) << 8;\
}

#endif

