//---------------------------------------------------------------------------
#pragma hdrstop
#include "ImgQueue.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TImgQueue::TImgQueue()
{
	CS = new TCriticalSection();
}

//---------------------------------------------------------------------------
TImgQueue::~TImgQueue()
{
	clear();
	delete CS;
}

//---------------------------------------------------------------------------
void TImgQueue::clear()
{
	CS->Enter();
	while (!Images.empty())
	{
		delete Images.front();
		Images.pop_front();
	}
	CS->Leave();
}

//---------------------------------------------------------------------------
void TImgQueue::push(TImg* Img)
{
	CS->Enter();
	Images.push_back(Img);
	CS->Leave();
}

//---------------------------------------------------------------------------
TImg* TImgQueue::pop()
{
	CS->Enter();
	TImg* Img = Images.front();
	Images.pop_front();
	CS->Leave();
	return Img;
}

//---------------------------------------------------------------------------
bool TImgQueue::empty()
{
	CS->Enter();
	bool Empty = Images.empty();
	CS->Leave();
	return Empty;
}

//---------------------------------------------------------------------------
unsigned int TImgQueue::size()
{
	CS->Enter();
	unsigned int Size = Images.size();
	CS->Leave();
	return Size;
}

//---------------------------------------------------------------------------
TImg* TImgQueue::get(unsigned int Index)
{
	CS->Enter();
	TImg* Img = Images[Index];
	CS->Leave();
	return Img;
}

