//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef ImgH
#define ImgH

//---------------------------------------------------------------------------
#include "avfile.h"
#include "CustomMM.h"

//---------------------------------------------------------------------------
class TImg
{
public:
	enum EPixelFormat {pfBGRA};

private:
	bool Allocated;
	BYTE *Bitmap, *Base;
	int Width, Height, LineWidth, ViewWidth, ViewHeight;
	static int Quality;

public:
	static TCustomMM *MemoryManager;
	static void SetupQuality(int _Quality);

	TImg();
	TImg(int _Width, int _Height);
	TImg(int _Width, int _Height, BYTE *_Bitmap, bool _Allocate = false);
	~TImg();

	void Create(int _Width, int _Height);
	void Create(int _Width, int _Height, BYTE *_Bitmap, bool _Allocate = false);
	void Create(int _Width, int _Height, int _LineWidth, BYTE *_Bitmap, bool _Allocate = false);

	void CopyFrom(TImg &Img);
	void ResizeFrom(TImg &Img);
	void CropFrom(TImg &Img);
	void CropResizeFrom(TImg &Img, int ResizeWidth, int ResizeHeight);
	void MoveTo(TImg &Img);
	void Free();

	void Clear();
	void Clip(int _Left, int _Top, int _Right, int _Bottom);

	void AutoAlpha();

	inline BYTE *GetBitmap();
	inline int GetWidth();
	inline int GetHeight();
	void GetSize(int &Width, int &Height);

	inline int GetLineWidth();
	inline int GetPixelWidth();

	void GetViewSize(int &Width, int &Height);
	void SetViewSize(int Width, int Height);

	inline EPixelFormat GetPixelFormat();
};

#endif

