//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "EffectZoom.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectZoom::TEffectZoom()
{
	Name = "Zoom";
	NeedFullFrame = false;
}

//---------------------------------------------------------------------------
TEffect* TEffectZoom::New()
{
	return new TEffectZoom();
}

//---------------------------------------------------------------------------
bool TEffectZoom::SetupVideo(TParameters &Parameters, char *Name)
{
	ReadyVideo = GetParameterFloat(Parameters, "Ratio", Zoom, Name) &&
		GetParameterFloat(Parameters, "CenterX", ZoomCenterX, Name) &&
		GetParameterFloat(Parameters, "CenterY", ZoomCenterY, Name);
	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectZoom::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo)
	{
		int Left = Img.GetWidth() * ZoomCenterX  - ((float(Img.GetWidth()) / 2.0) / Zoom);
		int Top = Img.GetHeight() * ZoomCenterY - ((float(Img.GetHeight()) / 2.0) / Zoom);
		int Right = Left + Img.GetWidth() / Zoom;
		int Bottom = Top + Img.GetHeight() / Zoom;

		if (Left >= 0 && Right < Img.GetWidth() && Top >= 0 && Bottom < Img.GetHeight())
		{
			Img.Clip(Left, Top, Right, Bottom);
		}
		else
		{
			int Width = Right - Left;
			int Height = Bottom - Top;

			TImg TMP(Width, Height);

			int ViewWidth, ViewHeight;
			Img.GetViewSize(ViewWidth, ViewHeight);
			TMP.SetViewSize(ViewWidth, ViewHeight);
			TMP.Clear();

			BYTE *Src = Img.GetBitmap();
			BYTE *Dst = TMP.GetBitmap();

			int Pixels = Width;
			if (Left < 0)
			{
				Pixels -= -Left;
				Dst += -Left * TMP.GetPixelWidth();
			}
			else
			{
				Src += Left * TMP.GetPixelWidth();
				if (Right >= Img.GetWidth())
					Pixels -= Right - Img.GetWidth();
			}

			int Lines = Height;
			if (Top < 0)
			{
				Lines -= -Top;
				Dst += -Top * TMP.GetLineWidth();
			}
			else
			{
				Src += Top * Img.GetLineWidth();
				if (Bottom >= Img.GetHeight())
					Lines -= Bottom - Img.GetHeight();
			}

			Pixels *= TMP.GetPixelWidth();
			for (int y = 0; y < Lines; y++)
			{
				memcpy(Dst, Src, Pixels);
				Src += Img.GetLineWidth();
				Dst += TMP.GetLineWidth();
			}

			TMP.MoveTo(Img);
		}
	}
}

