//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <vcl.h>
#include <windows.h>
#pragma hdrstop
#include "EffectText.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectText::TLine::TLine()
{
	Text = "";
	X = 0.5;
	Y = 0.5;
	HA = 0;
	VA = 0;
	Size = 12;
	Name = "Arial";
	Color = 0xffffff;
}

//---------------------------------------------------------------------------
TEffectText::TEffectText()
{
	Name = "Text";
}

//---------------------------------------------------------------------------
TEffect* TEffectText::New()
{
	return new TEffectText();
}

//---------------------------------------------------------------------------
bool TEffectText::SetupVideo(TParameters &Parameters, char *Name)
{
	Lines.clear();
	for (int i = 1;; i++)
	{
		AnsiString Text;
		if (GetParameterString(Parameters, ("Text" + IntToStr(i)).c_str(), Text, Name))
		{
			TLine Line;
			Line.Text = Text.c_str();
			GetParameterFloat(Parameters, ("PositionX" + IntToStr(i)).c_str(), Line.X, Name);
			GetParameterFloat(Parameters, ("PositionY" + IntToStr(i)).c_str(), Line.Y, Name);
			GetParameterInt(Parameters, ("Horizontal" + IntToStr(i)).c_str(), Line.HA, Name);
			GetParameterInt(Parameters, ("Vertical" + IntToStr(i)).c_str(), Line.VA, Name);
			GetParameterInt(Parameters, ("Size" + IntToStr(i)).c_str(), Line.Size, Name);
			GetParameterString(Parameters, ("Name" + IntToStr(i)).c_str(), Line.Name, Name);
			GetParameterHex(Parameters, ("Color" + IntToStr(i)).c_str(), Line.Color, Name);
			Lines.push_back(Line);
		}
		else
		{
			break;
		}
    }

	ReadyVideo = !Lines.empty();
	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectText::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo)
	{
		BITMAPINFO bmi;
		bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bmi.bmiHeader.biWidth = Img.GetWidth();
		bmi.bmiHeader.biHeight = -int(Img.GetHeight());
		bmi.bmiHeader.biPlanes = 1;
		bmi.bmiHeader.biBitCount = 32;
		bmi.bmiHeader.biCompression = BI_RGB;
		bmi.bmiHeader.biSizeImage = 0;
		bmi.bmiHeader.biXPelsPerMeter = 0;
		bmi.bmiHeader.biYPelsPerMeter = 0;
		bmi.bmiHeader.biClrUsed = 0;
		bmi.bmiHeader.biClrImportant = 0;

		HDC hDC = GetDC(NULL);
		if (hDC)
		{
			void *Temp;
			HBITMAP hSourceBitmap = CreateDIBSection(hDC, &bmi, DIB_RGB_COLORS, &Temp, NULL, 0);
			if (hSourceBitmap)
			{
				LPBYTE lpSourceBits = (LPBYTE)Temp;

				HDC hSourceDC = CreateCompatibleDC(hDC);
				if (hSourceDC)
				{
					memcpy(lpSourceBits, Img.GetBitmap(), Img.GetWidth() * Img.GetHeight() * 4);
					HBITMAP hOldSourceBitmap = (HBITMAP)SelectObject(hSourceDC, hSourceBitmap);
					SetBkMode(hSourceDC, TRANSPARENT);
					for (TLines::iterator i = Lines.begin(); i != Lines.end(); i++)
					{
						SetTextColor(hSourceDC, i->Color);
						TFont *Font = new TFont();
						Font->Name = i->Name.c_str();
						Font->Size = i->Size;

						HFONT hOldFont = (HFONT)SelectObject(hSourceDC, Font->Handle);
						int X = i->X * Img.GetWidth();
						int Y = i->Y * Img.GetHeight();

						RECT rect;
						SetRect(&rect, 0, 0, 0, 0);
						DrawText(hSourceDC, i->Text.c_str(), -1, &rect, DT_CALCRECT);

						int XO = 0, YO = 0;
						if (i->HA < 0)
						{
							XO = 0;
						}
						else if (i->HA > 0)
						{
							XO = -rect.right;
						}
						else
						{
							XO = -rect.right / 2;
						}

						if (i->VA < 0)
						{
							YO = 0;
						}
						else if (i->VA > 0)
						{
							YO = -rect.bottom;
						}
						else
						{
							YO = -rect.bottom / 2;
						}

						rect.left += X + XO;
						rect.right += X + XO;
						rect.top += Y + YO;
						rect.bottom += Y + YO;

						DrawText(hSourceDC, i->Text.c_str(), -1, &rect, 0);

						SelectObject(hSourceDC, hOldFont);
						delete Font;
					}
					SelectObject(hSourceDC, hOldSourceBitmap);
					memcpy(Img.GetBitmap(), lpSourceBits, Img.GetWidth() * Img.GetHeight() * 4);
					DeleteDC(hSourceDC);
				}
				DeleteObject(hSourceBitmap);
			}
			ReleaseDC(NULL, hDC);
			GdiFlush();
		}
	}
}

