//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "EffectStack.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectStack::TEffectStack()
{
	Name = "Stack";
	NeedFullFrame = false;
}

//---------------------------------------------------------------------------
TEffect* TEffectStack::New()
{
	return new TEffectStack();
}

//---------------------------------------------------------------------------
bool TEffectStack::SetupVideo(TParameters &Parameters, char *Name)
{
	ReadyVideo = GetParameterInt(Parameters, "Camera", Camera, Name);
	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectStack::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo && VideoStack)
	{
		TImg *TMP = new TImg();
		if (KeepData)
		{
			TMP->CopyFrom(Img);
		}
		else
		{
			Img.MoveTo(*TMP);
		}
		VideoStack->Insert(Camera, TMP);
	}
}

