//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "EffectPIP.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectPIP::TEffectPIP()
{
	Name = "PIP";
}

//---------------------------------------------------------------------------
TEffect* TEffectPIP::New()
{
	return new TEffectPIP();
}

//---------------------------------------------------------------------------
bool TEffectPIP::SetupVideo(TParameters &Parameters, char *Name)
{
	Zoom = ZoomX = ZoomY = 0;
	ReadyVideo = (GetParameterInt(Parameters, "Camera", Camera, Name) &&
	    GetParameterFloat(Parameters, "CenterX", CenterX, Name) &&
	    GetParameterFloat(Parameters, "CenterY", CenterY, Name) &&
	    ((GetParameterFloat(Parameters, "Ratio", Zoom, Name) && Zoom <= 1.0 && Zoom > 0) ||
	     (GetParameterFloat(Parameters, "RatioX", ZoomX, Name) && ZoomX <= 1.0 && ZoomX > 0 &&
	      GetParameterFloat(Parameters, "RatioY", ZoomY, Name) && ZoomY <= 1.0 && ZoomY > 0)));

	if (!GetParameterInt(Parameters, "Transparent", Transparent, Name))
	{
		Transparent = 0;
	}
	if (ReadyVideo)
	{
		if (Zoom <= 1.0 && Zoom > 0)
		{
			ZoomX = Zoom;
			ZoomY = Zoom;
		}
	}
	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectPIP::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo)
	{
		int Width = ZoomX * Img.GetWidth();
		int Height = ZoomY * Img.GetHeight();

		TImg TMP(Width, Height);
		GetFrame(Sources, Camera, TMP, true, Transparent);

		int Left = ((float(Img.GetWidth() * CenterX)) - float(TMP.GetWidth() / 2.0));
		int Top = ((float(Img.GetHeight() * CenterY)) - float(TMP.GetHeight() / 2.0));

		BYTE *Src = TMP.GetBitmap();
		BYTE *Dst = Img.GetBitmap();

		int Pixels = Width;
		if (Left < 0)
		{
			Pixels -= -Left;
			Src += -Left * TMP.GetPixelWidth();
		}
		else
		{
			Dst += Left * Img.GetPixelWidth();
			if ((Left + Width) >= Img.GetWidth())
			{
				Pixels -= (Left + Width) - Img.GetWidth();
			}
		}

		int Lines = Height;
		if (Top < 0)
		{
			Lines -= -Top;
			Src += -Top * TMP.GetLineWidth();
		}
		else
		{
			Dst += Top * Img.GetLineWidth();
			if ((Top + Height) >= Img.GetHeight())
			{
				Lines -= (Top + Height) - Img.GetHeight();
			}
		}

		if (Transparent)
		{
			for (int y = 0; y < Lines; y++)
			{
				int* SrcLine = (int*)Src;
				int* DstLine = (int*)Dst;
				for (int x = 0; x < Pixels; x++)
				{
					int sr, sg, sb, sa;
					sr = ((BYTE*)SrcLine)[0];
					sg = ((BYTE*)SrcLine)[1];
					sb = ((BYTE*)SrcLine)[2];
					sa = ((BYTE*)SrcLine)[3];

					int dr, dg, db;
					dr = ((BYTE*)DstLine)[0];
					dg = ((BYTE*)DstLine)[1];
					db = ((BYTE*)DstLine)[2];

					dr = (dr * sa + sr * (255 - sa)) / 255;
					dg = (dg * sa + sg * (255 - sa)) / 255;
					db = (db * sa + sb * (255 - sa)) / 255;
					/*
					dr = (sr * sa + dr * (255 - sa)) / 255;
					dg = (sg * sa + dg * (255 - sa)) / 255;
					db = (sb * sa + db * (255 - sa)) / 255;
					*/
					*DstLine = dr | dg << 8 | db << 16;

					SrcLine++;
					DstLine++;
				}
				Dst += Img.GetLineWidth();
				Src += TMP.GetLineWidth();
			}
		}
		else
		{
			Pixels *= TMP.GetPixelWidth();
			for (int y = 0; y < Lines; y++)
			{
				memcpy(Dst, Src, Pixels);
				Dst += Img.GetLineWidth();
				Src += TMP.GetLineWidth();
			}
		}
	}
}

