//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "EffectMix.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectMix::TEffectMix()
{
	Name = "Mix";
}

//---------------------------------------------------------------------------
TEffect* TEffectMix::New()
{
	return new TEffectMix();
}

//---------------------------------------------------------------------------
bool TEffectMix::SetupVideo(TParameters &Parameters, char *Name)
{
	ReadyVideo = GetParameterFloat(Parameters, "Percent", Percent, Name) &&
		GetParameterInt(Parameters, "Camera", Camera, Name);
	if (ReadyVideo)
	{
		if (Percent < 0.0)
		{
			Percent = 0.0;
		}
		else if (Percent > 100.0)
		{
			Percent = 100.0;
		}
	}
	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectMix::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo)
	{
		TImg TMP(Img.GetWidth(), Img.GetHeight());
		GetFrame(Sources, Camera, TMP);

		int Size = Img.GetWidth() * Img.GetHeight();
		BYTE *Frame = Img.GetBitmap();
		BYTE *MixFrame = TMP.GetBitmap();

		unsigned short p = 256 * Percent / 100;
		for (int i = 0; i < Size; i++)
		{
			Frame[0] = (Frame[0] * (256 - p) + MixFrame[0] * p) >> 8;
			Frame[1] = (Frame[1] * (256 - p) + MixFrame[1] * p) >> 8;
			Frame[2] = (Frame[2] * (256 - p) + MixFrame[2] * p) >> 8;
			Frame += 4;
			MixFrame += 4;
		}
	}
}

