//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "EffectHMirror.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectHMirror::TEffectHMirror()
{
	Name = "HMirror";
}

//---------------------------------------------------------------------------
TEffect* TEffectHMirror::New()
{
	return new TEffectHMirror();
}

//---------------------------------------------------------------------------
bool TEffectHMirror::SetupVideo(TParameters &Parameters, char *Name)
{
	ReadyVideo = true;
	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectHMirror::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo)
	{
		BYTE* Src = Img.GetBitmap() + 4 * (Img.GetWidth() - 1);
		BYTE* Dst = Img.GetBitmap();
		for (int y = 0; y < Img.GetHeight(); y++)
		{
			int *SrcLine = (int*)Src;
			int *DstLine = (int*)Dst;
			for (int x = 0; x < Img.GetWidth() / 2; x++)
			{
				int t = *DstLine;
				*(DstLine++) = *SrcLine;
				*(SrcLine--) = t;
			}
			Src += Img.GetLineWidth();
			Dst += Img.GetLineWidth();
		}
	}
}

