//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "EffectFade.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectFade::TEffectFade()
{
	Name = "Fade";
}

//---------------------------------------------------------------------------
TEffect* TEffectFade::New()
{
	return new TEffectFade();
}

//---------------------------------------------------------------------------
bool TEffectFade::SetupVideo(TParameters &Parameters, char *Name)
{
	ReadyVideo = GetParameterFloat(Parameters, "Percent", Percent, Name) &&
		GetParameterHex(Parameters, "Color", Color, Name);
	if (ReadyVideo)
	{
		if (Percent < 0.0)
		{
			Percent = 0.0;
		}
		else if (Percent > 100.0)
		{
			Percent = 100.0;
		}
	}
	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectFade::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo)
	{
		//int Size = Img.GetWidth() * Img.GetHeight();
		unsigned char R = Color & 0xff;
		unsigned char G = (Color >> 8) & 0xff;
		unsigned char B = (Color >> 16) & 0xff;
		unsigned short p = 256 * Percent / 100;

		BYTE *Frame = Img.GetBitmap();
		for (int y = 0; y < Img.GetHeight(); y++)
		{
			BYTE *Line = Frame;
			for (int x = 0; x < Img.GetWidth(); x++)
			{
				Line[0] = (Line[0] * (256 - p) + B * p) >> 8;
				Line[1] = (Line[1] * (256 - p) + G * p) >> 8;
				Line[2] = (Line[2] * (256 - p) + R * p) >> 8;
				Line += 4;
			}
			Frame += Img.GetLineWidth();
		}
		/*
		for (int i = 0; i < Size; i++)
		{
			Frame[0] = (Frame[0] * (256 - p) + B * p) >> 8;
			Frame[1] = (Frame[1] * (256 - p) + G * p) >> 8;
			Frame[2] = (Frame[2] * (256 - p) + R * p) >> 8;
			Frame += 4;
		}
		*/
	}
}

