//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <algorithm>
#pragma hdrstop
#include "EffectCrop.h"
#include "Tools.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectCrop::TEffectCrop()
{
	Name = "Crop";
	NeedFullFrame = false;
}

//---------------------------------------------------------------------------
TEffect* TEffectCrop::New()
{
	return new TEffectCrop();
}

//---------------------------------------------------------------------------
bool TEffectCrop::SetupVideo(TParameters &Parameters, char *Name)
{
	float L, T, R, B;
	ReadyVideo = GetParameterFloat(Parameters, "Left", L, Name) &&
		GetParameterFloat(Parameters, "Top", T, Name) &&
		GetParameterFloat(Parameters, "Right", R, Name) &&
		GetParameterFloat(Parameters, "Bottom", B, Name);

	if (ReadyVideo)
	{
		Left = min(max(min(L, R), 0), 1);
		Right = min(max(max(L, R), 0), 1);
		Top = min(max(min(T, B), 0), 1);
		Bottom = min(max(max(T, B), 0), 1);
	}

	return ReadyVideo;
}

//---------------------------------------------------------------------------
void TEffectCrop::DoVideo(TExtendedSources &Sources, TImg &Img)
{
	if (ReadyVideo)
	{
		int LeftInt = Left * Img.GetWidth();
		int RightInt = Right * Img.GetWidth();
		int TopInt = Top * Img.GetHeight();
		int BottomInt = Bottom * Img.GetHeight();

		if (LeftInt == 0 && TopInt == 0 && RightInt == Img.GetWidth() && BottomInt == Img.GetHeight())
		{
			return;
		}

		Img.Clip(LeftInt, TopInt, RightInt, BottomInt);
		int ViewWidth, ViewHeight;
		Img.GetViewSize(ViewWidth, ViewHeight);
		ViewWidth *= Right - Left;
		ViewHeight *= Bottom - Top;
		Img.SetViewSize(ViewWidth, ViewHeight);
	}
}

