//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include <iostream>
#pragma hdrstop
#include "EffectAudioFade.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectAudioFade::TEffectAudioFade()
{
	Name = "AudioFade";
}

//---------------------------------------------------------------------------
TEffect* TEffectAudioFade::New()
{
	return new TEffectAudioFade();
}

//---------------------------------------------------------------------------
bool TEffectAudioFade::SetupAudio(TParameters &Parameters, char *Name)
{
	ReadyAudio = GetParameterFloat(Parameters, "AudioFadePercentBegin", PercentBegin) &&
		GetParameterFloat(Parameters, "AudioFadePercentEnd", PercentEnd);
	return ReadyAudio;
}

//---------------------------------------------------------------------------
void TEffectAudioFade::DoAudio(TExtendedSources &Sources, TWave &Wave)
{
	if (ReadyAudio)
	{
		if (PercentBegin < 0.0)
		{
			PercentBegin = 0.0;
		}
		else if (PercentBegin > 100.0)
		{
			PercentBegin = 100.0;
		}
		if (PercentEnd < 0.0)
		{
			PercentEnd = 0.0;
		}
		else if (PercentEnd > 100.0)
		{
			PercentEnd = 100.0;
		}

		unsigned int d = 2 * Wave.Channels;
		if ((Wave.Size % d) == 0)
		{
			unsigned int Length = Wave.Size / d;
			short *Buffer = (short*)Wave.Wave;
			for (unsigned int s = 0; s < Length; s++)
			{
				float r = float(s) / float(Length - 1);
				r = 1.0 - ((PercentBegin * (1.0 - r) + PercentEnd * r) / 100.0);
				for (int ch = 0; ch < Wave.Channels; ch++)
				{
					*Buffer = float(*Buffer) * r;
					Buffer++;
				}
			}
		}
		else
		{
			std::cout << "\nerror\n";
		}
	}
}

