//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "EffectAudioBasic.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TEffectAudioBasic::TEffectAudioBasic()
{
	Name = "AudioBasic";
}

//---------------------------------------------------------------------------
TEffect* TEffectAudioBasic::New()
{
	return new TEffectAudioBasic();
}

//---------------------------------------------------------------------------
bool TEffectAudioBasic::SetupAudio(TParameters &Parameters, char *Name)
{
	ReadyAudio = true;
	return ReadyAudio;
}

//---------------------------------------------------------------------------
void TEffectAudioBasic::DoAudio(TExtendedSources &Sources, TWave &Wave)
{
	if (ReadyAudio)
	{
		TWave *Src = NULL;
		for (unsigned int i = 0; i < Sources.size() && Src == NULL; i++)
		{
			Src = Sources.GetAudio(i);
		}

		if (Src && Wave.Channels == Src->Channels && Wave.SamplesPerSec == Src->SamplesPerSec)
		{
			Wave.Assign(*Src);
		}
		else
		{
			Wave.Clear();
		}
	}
}

