//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef EffectH
#define EffectH

//---------------------------------------------------------------------------
#include <string>
#include "Events.h"
#include "Sources.h"
#include "Img.h"
#include "Wave.h"
#include "VideoStack.h"

//---------------------------------------------------------------------------
class TEffect
{
protected:
	char *Name;
	bool ReadyVideo, ReadyAudio, NeedFullFrame, NeedFrame, KeepData;
	static TVideoStack *VideoStack;
	static float InputAspectRatio;
	static int DefaultWidth;
	static int DefaultHeight;
	static int Quality;
	int BaseWidth, BaseHeight;

public:
	static void SetupVideoStack(TVideoStack *Stack);
	static void SetupDefaultSize(int Width, int Height);
	static void SetupQuality(int _Quality);

	TEffect();
	virtual TEffect* New();
	char* GetName();

	bool GetNeedFullFrame();
	bool GetNeedFrame();

	void GetFrame(TExtendedSources &Sources, int Camera, TImg &Img, bool KeepSize = false, bool AutoAlpha = false);
	void NoSignal(TImg &Img);

	virtual bool SetupVideo(ee::TParameters &Parameters, char *Name);
	virtual bool SetupAudio(ee::TParameters &Parameters, char *Name);
	virtual void DoVideo(TExtendedSources &Sources, TImg &Img);
	void DoVideoA(TExtendedSources &Sources, TImg &Img, bool KeepData, int BaseWidth, int BaseHeight);
	virtual void DoAudio(TExtendedSources &Sources, TWave &Wave);
};

#endif

