//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#pragma hdrstop
#include "Effect.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TVideoStack *TEffect::VideoStack = NULL;
float TEffect::InputAspectRatio = 0;
int TEffect::DefaultWidth = 0;
int TEffect::DefaultHeight = 0;
int TEffect::Quality = 0;

//---------------------------------------------------------------------------
void TEffect::SetupVideoStack(TVideoStack *Stack)
{
	VideoStack = Stack;
}

//---------------------------------------------------------------------------
void TEffect::SetupDefaultSize(int Width, int Height)
{
	DefaultWidth = Width;
	DefaultHeight = Height;
}

//---------------------------------------------------------------------------
void TEffect::SetupQuality(int _Quality)
{
	Quality = _Quality;
}

//---------------------------------------------------------------------------
TEffect::TEffect()
{
	ReadyVideo = ReadyAudio = false;
	NeedFullFrame = NeedFrame = KeepData = true;
	Name = "Empty";
}

//---------------------------------------------------------------------------
bool TEffect::GetNeedFullFrame()
{
	return NeedFullFrame;
}

//---------------------------------------------------------------------------
bool TEffect::GetNeedFrame()
{
	return NeedFrame;
}

//---------------------------------------------------------------------------
TEffect* TEffect::New()
{
	return new TEffect();
}

//---------------------------------------------------------------------------
char* TEffect::GetName()
{
	return Name;
}

//---------------------------------------------------------------------------
bool TEffect::SetupVideo(ee::TParameters &Parameters, char *Name)
{
	ReadyVideo = false;
	return ReadyVideo;
}

//---------------------------------------------------------------------------
bool TEffect::SetupAudio(ee::TParameters &Parameters, char *Name)
{
	ReadyAudio = false;
	return ReadyAudio;
}

//---------------------------------------------------------------------------
void TEffect::DoVideo(TExtendedSources &Sources, TImg &Img)
{
}

//---------------------------------------------------------------------------
void TEffect::DoAudio(TExtendedSources &Sources, TWave &Wave)
{
}

//---------------------------------------------------------------------------
void TEffect::GetFrame(TExtendedSources &Sources, int Camera, TImg &Img, bool KeepSize, bool AutoAlpha)
{
	TImg *Src;
	if ((Src = Sources.GetFrame(Camera)) != NULL)
	{
		/*
		if (AutoAlpha)
		{
			Src->AutoAlpha();
		}
		*/
		if (KeepSize)
		{
			Img.ResizeFrom(*Src);
		}
		else
		{
			Img.CopyFrom(*Src);
			Img.SetViewSize(BaseWidth, BaseHeight);
		}
	}
	else if (VideoStack != NULL && (Src = VideoStack->Get(Camera)) != NULL)
	{
		/*
		if (AutoAlpha)
		{
			Src->AutoAlpha();
		}
		*/
		if (KeepSize)
		{
			Img.ResizeFrom(*Src);
		}
		else
		{
			Img.CopyFrom(*Src);
			Img.SetViewSize(BaseWidth, BaseHeight);
		}
	}
	else
	{
		if (!KeepSize)
		{
			Img.Create(BaseWidth, BaseHeight);
		}
		NoSignal(Img);
	}
	/*
	if ((Src = Sources.GetFrame(Camera)) != NULL)
	{
		if (KeepSize)
		{
			Img.ResizeFrom(*Src);
		}
		else if (DefaultWidth > 0 && DefaultHeight > 0)
		{
			if (Img.GetWidth() != DefaultWidth || Img.GetHeight() != DefaultHeight)
			{
				Img.Create(DefaultWidth, DefaultHeight);
			}
			Img.ResizeFrom(*Src);
		}
		else
		{
			Img.CopyFrom(*Src);
		}
	}
	else if (VideoStack != NULL && (Src = VideoStack->Get(Camera)) != NULL)
	{
		if (KeepSize)
		{
			Img.ResizeFrom(*Src);
		}
		else
		{
			Img.CopyFrom(*Src);
		}
	}
	else
	{
		if (DefaultWidth > 0 && DefaultHeight > 0)
		{
			if (Img.GetWidth() != DefaultWidth || Img.GetHeight() != DefaultHeight)
			{
				Img.Create(DefaultWidth, DefaultHeight);
			}
		}
		NoSignal(Img);
	}
	*/
}

//---------------------------------------------------------------------------
void TEffect::NoSignal(TImg &Img)
{
	BYTE *Bitmap = Img.GetBitmap();
	/*
	for (int y = 0; y < 1; y++)
	{
		for (int x = 0; x < Img.GetWidth(); x++)
		{
			BYTE *Pixel = Bitmap;
			BYTE v = BYTE(8 * x / Img.GetWidth());
			Pixel[0] = (v & 1) ? 0xff : 0x00;
			Pixel[1] = (v & 2) ? 0xff : 0x00;
			Pixel[2] = (v & 4) ? 0xff : 0x00;
			Pixel[3] = 0;
			Bitmap += 4;
		}
	}
	int LineLen = Img.GetLineWidth();
	for (int y = 1; y < Img.GetHeight(); y++)
	{
		memcpy(Bitmap, Img.GetBitmap(), LineLen);
		Bitmap += LineLen;
	}
	*/
	int LineLen = Img.GetLineWidth();
	for (int y = 1; y < Img.GetHeight(); y++)
	{
		memset(Bitmap, 0, LineLen);
		Bitmap += LineLen;
	}
}

//---------------------------------------------------------------------------
void TEffect::DoVideoA(TExtendedSources &Sources, TImg &Img, bool KeepData, int BaseWidth, int BaseHeight)
{
	this->KeepData = KeepData;
	this->BaseWidth = BaseWidth;
	this->BaseHeight = BaseHeight;
	DoVideo(Sources, Img);
}

