//---------------------------------------------------------------------------
//	Video editor
//  2004 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//  Brno University of Technology
//  Faculty of Information Technology
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef EditorH
#define EditorH

//---------------------------------------------------------------------------
#include "Events.h"
#include "Sources.h"
#include "Effects.h"
#include "VideoStack.h"
#include "ImpExp.h"

//---------------------------------------------------------------------------
class TEditor
{
private:
	TEffects Effects, AudioEffects;
	TPEffects Graph, AudioGraph;
	TVideoStack VideoStack;

	int SetupRatioWidth, SetupRatioHeight;

	void FreeGraphs();

protected:
	AnsiString LoadedFileName;
	float SetupInputAspectRatio, SetupCropAspectRatio;

	TImpExp ImpExp;
	int OutputID;

	void UpdateSetup();

public:
	class TSaveOptions
	{
	public:
		int Start;
		int MaxLength;
		bool Video;
		bool Audio;
		int Type;
		int ResampleSources;
		int Quality;
		int AudioBitRate, VideoBitRate;
		std::string AudioCodec, VideoCodec;
		int Width, Height;

		TSaveOptions();
	};

	TExtendedSources Sources;

	TEditor();
	~TEditor();

	void Process(TImg *Frame, TWave *Wave);
	void SetParameters(ee::TParameters& Parameters);

	void Load(const char *FileName, const char *MediaPath = NULL);
	void Save(const char *FileName, TSaveOptions Options, void (*Progress)(int Pos, int Max));

	void AddVideoEffect(TEffect *Effect);
	void AddAudioEffect(TEffect *Effect);

	void SetupQuality(int Value);
};

#endif

