/*!
\file cvext.cpp

\author Juraj Blaho
\date 2008
\brief Extension to OpenCV
*/

#include "cvext.hpp"

int rects_overlapping(CvRect const &a, CvRect const &b){
	return (a.x<=b.x+b.width && b.x<=a.x+a.width) && /*horizontal overlap*/
	(a.y<=b.y+b.height && b.y<=a.y+a.height);        /*vertical overlap*/
}

int rect_inside(CvRect const &inner, CvRect const &outer){
	return (inner.x>=outer.x && inner.x+inner.width<=outer.x+outer.width) &&
	(inner.y>=outer.y && inner.y+inner.height<=outer.y+outer.height);
}
