//---------------------------------------------------------------------------
#pragma hdrstop
#include "DetectorDemo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
// Vola se pro kazdy snimek
void TDetectorDemo::Do(int Time, TImg &Img)
{
	// Musi tady zustat!

	// Tady bude kod detectoru.
	// Pokud bude neco rozpoznano, vysledek ulozit do Parameters.
	// Vysledky nemusi byt vraceny pro kazdy snimek.

	// Parametr Time je v ms.
	// Cas se bude vzdy zvetsovat, ale nektere snimky mohou byt vynechany!

	// Parametr Img obsahuje obrazek.
	// GetBitmap() - vrati ukazatel na bitmapu, nemenit obsah!
	// GetWidth(), GetHeight() - velikost v pixelech
	// GetPixelWidth() - pocet byte pixelu, bude 4
	// GetLineWidth() - delka radku v bytech, pozor muze byt vetsi nez GetWidth() * GetPixelWidth()!

	// Priklad detektoru - prumerna hodnota barevnych slozek
	int R, G, B;
	for (int c = 0; c < 10; c++)
	{
		BYTE *Bitmap = Img.GetBitmap();
		R = G = B = 0;

		for (int y = 0; y < Img.GetHeight(); y++)
		{
			BYTE *Line = Bitmap;
			for (int x = 0; x < Img.GetWidth(); x++)
			{
				B += Line[0];
				G += Line[1];
				R += Line[2];
				Line += Img.GetPixelWidth();
			}
			Bitmap += Img.GetLineWidth();
		}
	}
	int Count = Img.GetWidth() * Img.GetHeight();

	// Priklad ulozeni vysledku.
	/*
	Parameters.push_back(TParameter("R", FloatToStr((float)R / Count)));
	Parameters.push_back(TParameter("G", FloatToStr((float)G / Count)));
	Parameters.push_back(TParameter("B", FloatToStr((float)B / Count)));
	*/
}

