//---------------------------------------------------------------------------
#pragma hdrstop
#include "ComplexDetector.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
using namespace ee;

//---------------------------------------------------------------------------
TComplexDetector::TComplexDetector()
{
	InThread = false;
	MaxQueueLen = 0;
}

//---------------------------------------------------------------------------
TComplexDetector::~TComplexDetector()
{
	Break();
	for (std::vector<TDetectorDesc>::iterator i = Detectors.begin(); i != Detectors.end(); i++)
	{
		i->Thread->Terminate();
		i->Thread->WaitFor();
		delete i->Thread;
		delete i->Detector;
	}
	Detectors.clear();
}

//---------------------------------------------------------------------------
void TComplexDetector::SetConfiguration(char *Name, int Camera, ee::TParameters Configuration)
{
	for (std::vector<TDetectorDesc>::iterator i = Detectors.begin(); i != Detectors.end(); i++)
	{
		if (!strcmp(Name, i->Detector->GetName()))
		{
			i->Detector->SetConfiguration(Configuration);
		}
	}
}

//---------------------------------------------------------------------------
void TComplexDetector::Init(TExtendedSources &Sources, int MaxQueueSize)
{
	Break();
	Clear();

	MaxQueueLen = MaxQueueSize;
	int QueueLen = Sources.GetDelay();
	if (QueueLen > MaxQueueLen)
	{
		QueueLen = MaxQueueLen;
	}

	for (std::vector<TDetectorDesc>::iterator i = Detectors.begin(); i != Detectors.end(); i++)
	{
		i->Thread->Init(QueueLen);
		i->Detector->Init();
	}

	InThread = QueueLen > 0;
}

//---------------------------------------------------------------------------
void TComplexDetector::Break()
{
	for (std::vector<TDetectorDesc>::iterator i = Detectors.begin(); i != Detectors.end(); i++)
	{
		i->Thread->Break();
	}
}

//---------------------------------------------------------------------------
void TComplexDetector::Do(int Time, TExtendedSources &Sources)
{
	for (std::vector<TDetectorDesc>::iterator i = Detectors.begin(); i != Detectors.end(); i++)
	{
		TImg *Img = Sources.GetLastFrame(i->Camera);
		if (Img)
		{
			if (InThread)
			{
				i->Thread->Do(Time, Img);
			}
			else
			{
				i->Detector->Do(Time, *Img);
			}
		}
	}

	for (std::vector<TDetectorDesc>::iterator d = Detectors.begin(); d != Detectors.end(); d++)
	{
		ImpExp.Clear();
		if (InThread)
		{
			d->Thread->Get(ImpExp);
		}
		else
		{
			d->Detector->Get(ImpExp);
		}

		for (TEvents::iterator i = ImpExp.Events.begin(); i != ImpExp.Events.end(); i++)
		{
			(*i)->Parameters.push_back(TParameter("Camera", IntToStr(d->Camera)));
		}

		CopyEvents(ImpExp);
	}
}

//---------------------------------------------------------------------------
void TComplexDetector::AddDetector(TDetector *Detector, int Camera)
{
	TDetectorDesc d;
	d.Detector = Detector;
	d.Camera = Camera;
	d.Thread = new TDetectorThread(Detector);
	d.Thread->Resume();
	Detectors.push_back(d);
}

