/*!
\file exception.hpp

\author Juraj Blaho
\date 2008
\brief Exception classes
*/

#ifndef EXCEPTION_INCLUDED
#define EXCEPTION_INCLUDED

#include <exception>
#include <string>

class GeneralException:public std::exception{
	public:
		virtual const char* what() const throw()
		{
			return "Undefined exception";
		}
		
		virtual GeneralException Clone() const{
			return *this;
		}
		
		const char* What() const throw(){
			return what();
		}
};

class FileException:public GeneralException{
	public:
		virtual const char* what() const throw()
		{
			return "File exception";
		}
};

class FileFormatException:public FileException{
	public:
		virtual const char* what() const throw()
		{
			return "Invalid file format.";
		}
};

class OpenFileException:public FileException{
	private:
		std::string filename;
		std::string message;
	
	public:
		~OpenFileException() throw(){
		}
	
		OpenFileException(std::string filename_param):
			filename(filename_param),
			message(std::string("Unable to open file: ")+filename)
		{
		}
		
		virtual const char* what() const throw()
		{
			return message.c_str();
		}
};

class MemoryException:public GeneralException{
	public:
		virtual const char* what() const throw()
		{
			return "Memory exception";
		}
};

class MemoryAllocationException:public MemoryException{
	public:
		virtual const char* what() const throw()
		{
			return "Not enough memory";
		}
};

#endif

