#ifndef __BlahoDetector__h__
#define __BlahoDetector__h__


//---------------------------------------------------------------------------
#include "Detector.h"
#include "BlahoSkinmodel.h"
#include "BlahoTracker.h"
#include "Events.h"

#include <cv.h>
#include "cxcore.h"
#include "cvext.hpp"
#include "highgui.h"

#include <string>


//---------------------------------------------------------------------------
class TBlahoDetector: public TDetector
{

	const std::string faceDetectorFilename;
	const std::string skinDetectorFilename;
	const int skinThreshold;
	const int areaThreshold; 

	Tracker tracker;
	CvHaarClassifierCascade *faceDetectorCascade;

	CvMemStorage *storage;
	SkinModel skin;

	IplImage *frameSkin;
	IplImage *frameSmall;
	IplImage *frameGray;
	const double faceDetectionImageScale;
	int camera;

public:
	
	TBlahoDetector();
	TBlahoDetector(int Camera);

	virtual void Init();
	virtual void Do(int Time, TImg &Img);

	virtual ~TBlahoDetector();
};


#endif