/*!
\file cvext.hpp

\author Juraj Blaho
\date 2008
\brief Extension to OpenCV
*/

#ifndef _CVEXT_H_
#define _CVEXT_H_

#include <cxcore.h>

#include <iostream>

/*! The R offset in multichannel image*/
#define R_OFFSET 2
/*! The G offset in multichannel image*/
#define G_OFFSET 1
/*! The B offset in multichannel image*/
#define B_OFFSET 0
/*! The A offset in multichannel image*/
#define A_OFFSET 3

/*! Pointer to the element in multichanel uchar image*/
#define IMG_ELEM_NU(IMG, Y, X) (((uchar *)((IMG)->imageData + (Y)*(IMG)->widthStep))+(X)*(IMG)->nChannels)

/*! Pointer to the element in singlechannel uchar image*/
#define IMG_ELEM_1U(IMG, Y, X) (((uchar *)((IMG)->imageData + (Y)*(IMG)->widthStep))+(X))

/*! 
Check wheter rectangles are overlaping

\return Non-zero when rectangles are overlapping 
*/
int rects_overlapping(CvRect const &a, CvRect const &b);

/*!
Check whether one rectangle is in another

\return Non-zer when rectangle inner is in the outer
*/
int rect_inside(CvRect const &inner, CvRect const &outer);

/*!
\brief Image Allocator.

The image assigned to allocator is automatically destroyed when destructor is called.
*/
class ImageAllocator{
	IplImage *_image;
	
	public:
	
	ImageAllocator():
		_image(0)
	{
		std::cout<<"image created"<<std::endl;
	}
	
	~ImageAllocator(){
		cvReleaseImage(&_image);
		std::cout<<"image destroyed"<<std::endl;
	}
	
	IplImage *operator =(IplImage *image){
		cvReleaseImage(&_image);
		_image=image;
		return _image;
	}
	
	IplImage *Image() const{
		return _image;
	}
};

#endif
